/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.util;

public class ArrayConverter {
    private static final int SHORT_SIZE = 2;
    private static final int INT_SIZE = 4;

    private ArrayConverter() {
    }

    private static void checkArray(byte[] array, int offset, int length) throws IllegalArgumentException {
        if (array == null) {
            throw new IllegalArgumentException("Array must not be null.");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("Array index must not be negative.");
        }
        if (length < 1) {
            throw new IllegalArgumentException("Length of value must not be smaller than one.");
        }
        if (offset >= array.length) {
            throw new IllegalArgumentException("Offset " + offset + " is invalid, must be smaller than array length " + array.length + ".");
        }
        if (offset + length > array.length) {
            throw new IllegalArgumentException("Value of length " + length + " does not fit at offset " + offset + " into an array of length " + array.length + ".");
        }
    }

    public static void convertPacked2BitIntensityTo8Bit(byte[] src, int srcOffset, byte[] dest, int destOffset, int numPackedBytes) {
        while (numPackedBytes-- > 0) {
            int srcValue = src[srcOffset++] & 0xFF;
            dest[destOffset++] = (byte)((srcValue >> 6 & 3) * 85);
            dest[destOffset++] = (byte)((srcValue >> 4 & 3) * 85);
            dest[destOffset++] = (byte)((srcValue >> 2 & 3) * 85);
            dest[destOffset++] = (byte)((srcValue & 3) * 85);
        }
    }

    public static void convertPacked4BitIntensityTo8Bit(byte[] src, int srcOffset, byte[] dest, int destOffset, int numPackedBytes) {
        while (numPackedBytes-- > 0) {
            int srcValue = src[srcOffset++] & 0xFF;
            dest[destOffset++] = (byte)(srcValue & 0xF0 | (srcValue & 0xF0) >> 4);
            dest[destOffset++] = (byte)(srcValue & 0xF | (srcValue & 0xF) << 4);
        }
    }

    public static void copyPackedBytes(byte[] src, int srcOffset, int srcBitOffset, byte[] dest, int destOffset, int destBitOffset, int numSamples) {
        if (numSamples < 0) {
            throw new IllegalArgumentException("Number of samples to be copied must be 0 or larger.");
        }
        if (srcBitOffset == 0 && destBitOffset == 0 && numSamples > 7) {
            int bytes = numSamples >> 3;
            System.arraycopy(src, srcOffset, dest, destOffset, bytes);
            srcOffset += bytes;
            destOffset += bytes;
            numSamples &= 7;
        }
        int srcMask = 1 << 7 - srcBitOffset;
        int destMask = 1 << 7 - destBitOffset;
        while (numSamples-- != 0) {
            if ((src[srcOffset] & srcMask) == 0) {
                int n = destOffset;
                dest[n] = (byte)(dest[n] & (byte)(255 - destMask));
            } else {
                int n = destOffset;
                dest[n] = (byte)(dest[n] | (byte)destMask);
            }
            if (srcMask == 1) {
                srcMask = 128;
                ++srcOffset;
            } else {
                srcMask >>= 1;
            }
            if (destMask == 1) {
                destMask = 128;
                ++destOffset;
                continue;
            }
            destMask >>= 1;
        }
    }

    public static void decodePacked1Bit(byte[] src, int srcOffset, byte[] dest, int destOffset, int numPackedBytes) {
        while (numPackedBytes-- != 0) {
            int srcValue = src[srcOffset++] & 0xFF;
            dest[destOffset++] = (byte)(srcValue >> 7 & 1);
            dest[destOffset++] = (byte)(srcValue >> 6 & 1);
            dest[destOffset++] = (byte)(srcValue >> 5 & 1);
            dest[destOffset++] = (byte)(srcValue >> 4 & 1);
            dest[destOffset++] = (byte)(srcValue >> 3 & 1);
            dest[destOffset++] = (byte)(srcValue >> 2 & 1);
            dest[destOffset++] = (byte)(srcValue >> 1 & 1);
            dest[destOffset++] = (byte)(srcValue & 1);
        }
    }

    public static void decodePacked2Bit(byte[] src, int srcOffset, byte[] dest, int destOffset, int numPackedBytes) {
        while (numPackedBytes-- != 0) {
            int srcValue = src[srcOffset++] & 0xFF;
            dest[destOffset++] = (byte)(srcValue >> 6);
            dest[destOffset++] = (byte)(srcValue >> 4 & 3);
            dest[destOffset++] = (byte)(srcValue >> 2 & 3);
            dest[destOffset++] = (byte)(srcValue & 3);
        }
    }

    public static void decodePacked4Bit(byte[] src, int srcOffset, byte[] dest, int destOffset, int numPackedBytes) {
        while (numPackedBytes-- > 0) {
            int srcValue = src[srcOffset++] & 0xFF;
            dest[destOffset++] = (byte)(srcValue >> 4);
            dest[destOffset++] = (byte)(srcValue & 0xF);
        }
    }

    public static void decodePackedRGB565BigEndianToRGB24(byte[] src, int srcOffset, byte[] red, int redOffset, byte[] green, int greenOffset, byte[] blue, int blueOffset, int numPixels) {
        while (numPixels-- != 0) {
            int pixel = (src[srcOffset] & 0xFF) << 8 | src[srcOffset + 1] & 0xFF;
            srcOffset += 2;
            int r = pixel >> 11 & 0x1F;
            int g = pixel >> 5 & 0x3F;
            int b = pixel & 0x1F;
            red[redOffset++] = (byte)(r << 3 | r >> 2 & 7);
            green[greenOffset++] = (byte)(g << 2 | g >> 4 & 3);
            blue[blueOffset++] = (byte)(b << 3 | b >> 2 & 7);
        }
    }

    public static void encodePacked2Bit(byte[] src, int srcOffset, byte[] dest, int destOffset, int numSamples) {
        int numBytes = numSamples / 4;
        while (numBytes-- != 0) {
            int b1 = src[srcOffset++] & 3;
            int b2 = src[srcOffset++] & 3;
            int b3 = src[srcOffset++] & 3;
            int b4 = src[srcOffset++] & 3;
            dest[destOffset++] = (byte)(b1 << 6 | b2 << 4 | b3 << 2 | b4);
        }
        if ((numSamples %= 4) > 0) {
            int value = 0;
            int mask = 6;
            while (numSamples-- != 0) {
                value |= (src[srcOffset++] & 3) << mask;
                mask -= 2;
            }
            dest[destOffset] = (byte)value;
        }
    }

    public static void encodePacked4Bit(byte[] src, int srcOffset, byte[] dest, int destOffset, int numSamples) {
        int numBytes = numSamples / 2;
        while (numBytes-- != 0) {
            int b1 = src[srcOffset++] & 0xF;
            int b2 = src[srcOffset++] & 0xF;
            dest[destOffset++] = (byte)(b1 << 4 | b2);
        }
        if (numSamples % 2 == 1) {
            dest[destOffset] = (byte)((src[srcOffset] & 0xF) << 4);
        }
    }

    public static void encodeRGB24ToPackedRGB565BigEndian(byte[] red, int redOffset, byte[] green, int greenOffset, byte[] blue, int blueOffset, byte[] dest, int destOffset, int numPixels) {
        while (numPixels-- != 0) {
            int r = (red[redOffset++] & 0xFF) >> 3;
            int g = (green[greenOffset++] & 0xFF) >> 2;
            int b = (blue[blueOffset++] & 0xFF) >> 3;
            int pixel = r << 11 | g << 5 | b;
            dest[destOffset++] = (byte)(pixel >> 8);
            dest[destOffset++] = (byte)(pixel & 0xFF);
        }
    }

    public static int getIntBE(byte[] src, int srcOffset) {
        ArrayConverter.checkArray(src, srcOffset, 4);
        return src[srcOffset + 3] & 0xFF | (src[srcOffset + 2] & 0xFF) << 8 | (src[srcOffset + 1] & 0xFF) << 16 | (src[srcOffset] & 0xFF) << 24;
    }

    public static int getIntLE(byte[] src, int srcOffset) {
        ArrayConverter.checkArray(src, srcOffset, 4);
        return src[srcOffset] & 0xFF | (src[srcOffset + 1] & 0xFF) << 8 | (src[srcOffset + 2] & 0xFF) << 16 | (src[srcOffset + 3] & 0xFF) << 24;
    }

    public static short getShortBE(byte[] src, int srcOffset) {
        ArrayConverter.checkArray(src, srcOffset, 2);
        return (short)((src[srcOffset++] & 0xFF) << 8 | src[srcOffset++] & 0xFF);
    }

    public static int getShortBEAsInt(byte[] src, int srcOffset) {
        ArrayConverter.checkArray(src, srcOffset, 2);
        return (src[srcOffset++] & 0xFF) << 8 | src[srcOffset++] & 0xFF;
    }

    public static short getShortLE(byte[] src, int srcOffset) {
        ArrayConverter.checkArray(src, srcOffset, 2);
        return (short)(src[srcOffset++] & 0xFF | (src[srcOffset++] & 0xFF) << 8);
    }

    public static void setIntBE(byte[] dest, int destOffset, int newValue) {
        ArrayConverter.checkArray(dest, destOffset, 4);
        dest[destOffset] = (byte)(newValue >> 24 & 0xFF);
        dest[destOffset + 1] = (byte)(newValue >> 16 & 0xFF);
        dest[destOffset + 2] = (byte)(newValue >> 8 & 0xFF);
        dest[destOffset + 3] = (byte)(newValue & 0xFF);
    }

    public static void setIntLE(byte[] dest, int destOffset, int newValue) {
        ArrayConverter.checkArray(dest, destOffset, 4);
        dest[destOffset] = (byte)(newValue & 0xFF);
        dest[destOffset + 1] = (byte)(newValue >> 8 & 0xFF);
        dest[destOffset + 2] = (byte)(newValue >> 16 & 0xFF);
        dest[destOffset + 3] = (byte)(newValue >> 24 & 0xFF);
    }

    public static void setShortBE(byte[] dest, int destOffset, short newValue) {
        ArrayConverter.checkArray(dest, destOffset, 2);
        dest[destOffset] = (byte)(newValue >> 8 & 0xFF);
        dest[destOffset + 1] = (byte)(newValue & 0xFF);
    }

    public static void setShortLE(byte[] dest, int destOffset, short newValue) {
        ArrayConverter.checkArray(dest, destOffset, 2);
        dest[destOffset + 1] = (byte)(newValue >> 8 & 0xFF);
        dest[destOffset] = (byte)(newValue & 0xFF);
    }
}

