/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.ops;

import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.Operation;
import net.sourceforge.jiu.ops.WrongParameterException;

public abstract class ImageToImageOperation
extends Operation {
    private PixelImage inputImage;
    private PixelImage outputImage;
    private boolean canInAndOutBeEqual;

    public ImageToImageOperation(PixelImage in, PixelImage out) {
        this.setInputImage(in);
        this.setOutputImage(out);
        this.canInAndOutBeEqual = false;
    }

    public ImageToImageOperation(PixelImage in) {
        this(in, null);
    }

    public ImageToImageOperation() {
        this(null, null);
    }

    public boolean canInputAndOutputBeEqual() {
        return this.canInAndOutBeEqual;
    }

    public void ensureImagesHaveSameResolution() throws WrongParameterException {
        PixelImage in = this.getInputImage();
        PixelImage out = this.getOutputImage();
        if (in != null && out != null) {
            if (in.getWidth() != out.getWidth()) {
                throw new WrongParameterException("Input and output image must have the same width.");
            }
            if (in.getHeight() != out.getHeight()) {
                throw new WrongParameterException("Input and output image must have the same height.");
            }
        }
    }

    public void ensureInputImageIsAvailable() throws MissingParameterException {
        if (this.getInputImage() == null) {
            throw new MissingParameterException("Input image missing.");
        }
    }

    public void ensureOutputImageResolution(int width, int height) throws WrongParameterException {
        PixelImage out = this.getOutputImage();
        if (out != null) {
            if (out.getWidth() != width) {
                throw new WrongParameterException("Output image must have width " + width + " (got: " + out.getWidth() + ").");
            }
            if (out.getHeight() != height) {
                throw new WrongParameterException("Output image must have height " + height + " (got: " + out.getHeight() + ").");
            }
        }
    }

    public PixelImage getInputImage() {
        return this.inputImage;
    }

    public PixelImage getOutputImage() {
        return this.outputImage;
    }

    public void setCanInputAndOutputBeEqual(boolean newValue) {
        this.canInAndOutBeEqual = newValue;
    }

    public void setInputImage(PixelImage in) {
        this.inputImage = in;
    }

    public void setOutputImage(PixelImage out) {
        this.outputImage = out;
    }
}

