/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.gui.awt.dialogs;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import net.sourceforge.jiu.apps.Strings;
import net.sourceforge.jiu.gui.awt.dialogs.Dialogs;

public class WindowSizeDialog
extends Dialog
implements ActionListener,
KeyListener {
    private Button ok;
    private Button cancel;
    private TextField width;
    private TextField height;
    private boolean pressedOk = false;

    public WindowSizeDialog(Frame owner, Strings strings, int titleIndex, int initialWidth, int initialHeight) {
        super(owner, strings.get(titleIndex), true);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(0, 2));
        panel.add(new Label(strings.get(155)));
        panel.add(new Label(""));
        panel.add(new Label(strings.get(153)));
        this.width = new TextField(Integer.toString(initialWidth));
        this.width.addKeyListener(this);
        panel.add(this.width);
        panel.add(new Label(strings.get(154)));
        this.height = new TextField(Integer.toString(initialHeight));
        this.height.addKeyListener(this);
        panel.add(this.height);
        this.add((Component)panel, "Center");
        this.ok = new Button(strings.get(64));
        this.ok.addActionListener(this);
        this.cancel = new Button(strings.get(65));
        this.cancel.addActionListener(this);
        panel = new Panel();
        panel.add(this.ok);
        panel.add(this.cancel);
        this.add((Component)panel, "South");
        this.updateOkButton();
        this.pack();
        Dialogs.center(this);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.ok) {
            this.pressedOk = true;
            this.setVisible(false);
        } else if (e.getSource() == this.cancel) {
            this.setVisible(false);
        }
    }

    public int getHeightValue() {
        return this.getValue(this.height);
    }

    public int getWidthValue() {
        return this.getValue(this.width);
    }

    private int getValue(TextComponent textField) {
        try {
            return Integer.parseInt(textField.getText());
        }
        catch (NumberFormatException nfe) {
            return -1000;
        }
    }

    public boolean hasPressedOk() {
        return this.pressedOk;
    }

    private void updateOkButton() {
        int w = this.getWidthValue();
        int h = this.getHeightValue();
        this.ok.setEnabled(w >= 1 && h >= 1 && w % 2 == 1 && h % 2 == 1);
    }

    public void keyPressed(KeyEvent e) {
        this.updateOkButton();
    }

    public void keyReleased(KeyEvent e) {
        this.updateOkButton();
    }

    public void keyTyped(KeyEvent e) {
        this.updateOkButton();
    }
}

