/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.gui.awt;

public class RGBA {
    public static final int DEFAULT_ALPHA = -16777216;

    private RGBA() {
    }

    public static void convertFromPackedBilevel(byte[] src, int srcOffset, int alpha, int[] dest, int destOffset, int num) {
        int BLACK = alpha;
        int WHITE = alpha | 0xFFFFFF;
        int mask = 1;
        int value = 0;
        while (num-- > 0) {
            if (mask == 1) {
                mask = 128;
                value = src[srcOffset++] & 0xFF;
            } else {
                mask >>= 1;
            }
            dest[destOffset++] = (value & mask) == 0 ? BLACK : WHITE;
        }
    }

    public static void convertFromGray8(byte[] src, int srcOffset, int alpha, int[] dest, int destOffset, int num) {
        while (num-- > 0) {
            int grayValue = src[srcOffset++] & 0xFF;
            dest[destOffset++] = alpha | grayValue | grayValue << 8 | grayValue << 16;
        }
    }

    public static void convertFromGray16(short[] src, int srcOffset, int alpha, int[] dest, int destOffset, int num) {
        while (num-- > 0) {
            int grayValue = (src[srcOffset++] & 0xFFFF) >> 8;
            dest[destOffset++] = alpha | grayValue | grayValue << 8 | grayValue << 16;
        }
    }

    public static void convertFromPaletted8(byte[] src, int srcOffset, int alpha, int[] red, int[] green, int[] blue, int[] dest, int destOffset, int num) {
        while (num-- > 0) {
            int index = src[srcOffset++] & 0xFF;
            dest[destOffset++] = alpha | blue[index] | green[index] << 8 | red[index] << 16;
        }
    }

    public static void convertFromRGB24(byte[] srcRed, int srcRedOffset, byte[] srcGreen, int srcGreenOffset, byte[] srcBlue, int srcBlueOffset, int alpha, int[] dest, int destOffset, int num) {
        while (num-- > 0) {
            dest[destOffset++] = alpha | srcBlue[srcBlueOffset++] & 0xFF | (srcGreen[srcGreenOffset++] & 0xFF) << 8 | (srcRed[srcRedOffset++] & 0xFF) << 16;
        }
    }

    public static void convertFromRGB48(short[] srcRed, int srcRedOffset, short[] srcGreen, int srcGreenOffset, short[] srcBlue, int srcBlueOffset, int alpha, int[] dest, int destOffset, int num) {
        while (num-- > 0) {
            dest[destOffset++] = alpha | (srcBlue[srcBlueOffset++] & 0xFF00) >> 8 | srcGreen[srcGreenOffset++] & 0xFF00 | (srcRed[srcRedOffset++] & 0xFF00) << 8;
        }
    }
}

