/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.gui.awt;

import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import net.sourceforge.jiu.data.BilevelImage;
import net.sourceforge.jiu.data.Gray16Image;
import net.sourceforge.jiu.data.Gray8Image;
import net.sourceforge.jiu.data.MemoryRGB24Image;
import net.sourceforge.jiu.data.Palette;
import net.sourceforge.jiu.data.Paletted8Image;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.data.RGB24Image;
import net.sourceforge.jiu.data.RGB48Image;
import net.sourceforge.jiu.gui.awt.RGBA;

public class ImageCreator {
    public static final int DEFAULT_ALPHA = -16777216;
    private static Frame frame;

    private ImageCreator() {
    }

    public static Image createImage(int[] pixels, int width, int height) {
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("Error -- width and height must both be larger than zero.");
        }
        if (pixels == null) {
            throw new IllegalArgumentException("Error -- the pixel array must be non-null.");
        }
        if (pixels.length < width * height) {
            throw new IllegalArgumentException("Error -- the pixel array must contain at least width times height items.");
        }
        if (frame == null) {
            frame = new Frame();
        }
        return frame.createImage(new MemoryImageSource(width, height, pixels, 0, width));
    }

    public static Image convertToAwtImage(PixelImage image, int alpha) {
        if (image == null) {
            return null;
        }
        if (image instanceof RGB24Image) {
            return ImageCreator.convertToAwtImage((RGB24Image)image, alpha);
        }
        if (image instanceof RGB48Image) {
            return ImageCreator.convertToAwtImage((RGB48Image)image, alpha);
        }
        if (image instanceof Gray8Image) {
            return ImageCreator.convertToAwtImage((Gray8Image)image, alpha);
        }
        if (image instanceof Gray16Image) {
            return ImageCreator.convertToAwtImage((Gray16Image)image, alpha);
        }
        if (image instanceof Paletted8Image) {
            return ImageCreator.convertToAwtImage((Paletted8Image)image, alpha);
        }
        if (image instanceof BilevelImage) {
            return ImageCreator.convertToAwtImage((BilevelImage)image, alpha);
        }
        return null;
    }

    public static Image convertToAwtImage(BilevelImage image, int alpha) {
        if (image == null) {
            return null;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit == null) {
            return null;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        if (width < 1 || height < 1) {
            return null;
        }
        int bytesPerRow = (width + 7) / 8;
        int[] pixels = new int[width * height];
        byte[] row = new byte[bytesPerRow];
        int destOffset = 0;
        int y = 0;
        while (y < height) {
            image.getPackedBytes(0, y, width, row, 0, 0);
            RGBA.convertFromPackedBilevel(row, 0, alpha, pixels, destOffset, width);
            destOffset += width;
            ++y;
        }
        return toolkit.createImage(new MemoryImageSource(width, height, pixels, 0, width));
    }

    public static Image convertToAwtImage(Gray16Image image, int alpha) {
        if (image == null) {
            return null;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit == null) {
            return null;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        if (width < 1 || height < 1) {
            return null;
        }
        int[] pixels = new int[width * height];
        short[] gray = new short[width];
        int destOffset = 0;
        int y = 0;
        while (y < height) {
            image.getShortSamples(0, 0, y, width, 1, gray, 0);
            RGBA.convertFromGray16(gray, 0, alpha, pixels, destOffset, width);
            destOffset += width;
            ++y;
        }
        return toolkit.createImage(new MemoryImageSource(width, height, pixels, 0, width));
    }

    public static Image convertToAwtImage(Gray8Image image, int alpha) {
        if (image == null) {
            return null;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit == null) {
            return null;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        if (width < 1 || height < 1) {
            return null;
        }
        int[] pixels = new int[width * height];
        byte[] gray = new byte[width];
        int destOffset = 0;
        int y = 0;
        while (y < height) {
            image.getByteSamples(0, 0, y, width, 1, gray, 0);
            RGBA.convertFromGray8(gray, 0, alpha, pixels, destOffset, width);
            destOffset += width;
            ++y;
        }
        return toolkit.createImage(new MemoryImageSource(width, height, pixels, 0, width));
    }

    public static Image convertToAwtImage(Paletted8Image image, int alpha) {
        if (image == null) {
            return null;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit == null) {
            return null;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        Palette palette = image.getPalette();
        if (width < 1 || height < 1 || palette == null) {
            return null;
        }
        int[] red = new int[palette.getNumEntries()];
        int[] green = new int[palette.getNumEntries()];
        int[] blue = new int[palette.getNumEntries()];
        int i = 0;
        while (i < palette.getNumEntries()) {
            red[i] = palette.getSample(0, i);
            green[i] = palette.getSample(1, i);
            blue[i] = palette.getSample(2, i);
            ++i;
        }
        int[] pixels = new int[width * height];
        byte[] data = new byte[width];
        int destOffset = 0;
        int y = 0;
        while (y < height) {
            image.getByteSamples(0, 0, y, width, 1, data, 0);
            RGBA.convertFromPaletted8(data, 0, alpha, red, green, blue, pixels, destOffset, width);
            destOffset += width;
            ++y;
        }
        return toolkit.createImage(new MemoryImageSource(width, height, pixels, 0, width));
    }

    public static Image convertToAwtImage(RGB24Image image, int alpha) {
        if (image == null) {
            return null;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit == null) {
            return null;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        if (width < 1 || height < 1) {
            return null;
        }
        int[] pixels = new int[width * height];
        byte[] red = new byte[width];
        byte[] green = new byte[width];
        byte[] blue = new byte[width];
        int destOffset = 0;
        int y = 0;
        while (y < height) {
            image.getByteSamples(0, 0, y, width, 1, red, 0);
            image.getByteSamples(1, 0, y, width, 1, green, 0);
            image.getByteSamples(2, 0, y, width, 1, blue, 0);
            RGBA.convertFromRGB24(red, 0, green, 0, blue, 0, alpha, pixels, destOffset, width);
            destOffset += width;
            ++y;
        }
        return toolkit.createImage(new MemoryImageSource(width, height, pixels, 0, width));
    }

    public static Image convertToAwtImage(RGB48Image image, int alpha) {
        if (image == null) {
            return null;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit == null) {
            return null;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        if (width < 1 || height < 1) {
            return null;
        }
        int[] pixels = new int[width * height];
        short[] red = new short[width];
        short[] green = new short[width];
        short[] blue = new short[width];
        int destOffset = 0;
        int y = 0;
        while (y < height) {
            image.getShortSamples(0, 0, y, width, 1, red, 0);
            image.getShortSamples(1, 0, y, width, 1, green, 0);
            image.getShortSamples(2, 0, y, width, 1, blue, 0);
            RGBA.convertFromRGB48(red, 0, green, 0, blue, 0, alpha, pixels, destOffset, width);
            destOffset += width;
            ++y;
        }
        return toolkit.createImage(new MemoryImageSource(width, height, pixels, 0, width));
    }

    public static RGB24Image convertImageToRGB24Image(Image image) {
        if (image == null) {
            return null;
        }
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        if (width < 1 || height < 1) {
            return null;
        }
        int[] pixels = new int[width * height];
        PixelGrabber pg = new PixelGrabber(image, 0, 0, width, height, pixels, 0, width);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            return null;
        }
        if ((pg.getStatus() & 0x80) != 0) {
            return null;
        }
        MemoryRGB24Image result = new MemoryRGB24Image(width, height);
        int offset = 0;
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int pixel = pixels[offset++] & 0xFFFFFF;
                result.putSample(0, x, y, pixel >> 16);
                result.putSample(1, x, y, pixel >> 8 & 0xFF);
                result.putSample(2, x, y, pixel & 0xFF);
                ++x;
            }
            ++y;
        }
        return result;
    }
}

