/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.geometry;

import net.sourceforge.jiu.data.IntegerImage;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.ops.ImageToImageOperation;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.WrongParameterException;

public class ScaleReplication
extends ImageToImageOperation {
    private Integer outWidth;
    private Integer outHeight;

    private void process(IntegerImage in, IntegerImage out) {
        if (out == null) {
            out = (IntegerImage)in.createCompatibleImage(this.outWidth, this.outHeight);
            this.setOutputImage(out);
        }
        int IN_MAX_X = in.getWidth() - 1;
        int IN_MAX_Y = in.getHeight() - 1;
        int OUT_WIDTH = this.outWidth;
        int OUT_HEIGHT = this.outHeight;
        int y = 0;
        while (y < OUT_HEIGHT) {
            int SRC_Y = IN_MAX_Y * (y + 1) / OUT_HEIGHT;
            int x = 0;
            while (x < OUT_WIDTH) {
                int SRC_X = IN_MAX_X * (x + 1) / OUT_WIDTH;
                int c = 0;
                while (c < in.getNumChannels()) {
                    out.putSample(c, x, y, in.getSample(c, SRC_X, SRC_Y));
                    ++c;
                }
                ++x;
            }
            this.setProgress(y, OUT_HEIGHT);
            ++y;
        }
    }

    public void process() throws MissingParameterException, WrongParameterException {
        PixelImage pin = this.getInputImage();
        if (pin == null) {
            throw new MissingParameterException("Input image object missing.");
        }
        if (!(pin instanceof IntegerImage)) {
            throw new WrongParameterException("ScaleReplication only works on IntegerImage objects.");
        }
        if (this.outWidth == null) {
            throw new MissingParameterException("Output width value missing.");
        }
        if (this.outHeight == null) {
            throw new MissingParameterException("Output height value missing.");
        }
        this.ensureImagesHaveSameResolution();
        this.process((IntegerImage)pin, (IntegerImage)this.getOutputImage());
    }

    public void setSize(int width, int height) {
        if (width < 1) {
            throw new IllegalArgumentException("Output width must be larger than 0.");
        }
        if (height < 1) {
            throw new IllegalArgumentException("Output height must be larger than 0.");
        }
        this.outWidth = new Integer(width);
        this.outHeight = new Integer(height);
    }
}

