/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.data;

import net.sourceforge.jiu.data.MemoryByteChannelImage;
import net.sourceforge.jiu.data.Palette;
import net.sourceforge.jiu.data.Paletted8Image;
import net.sourceforge.jiu.data.PixelImage;

public class MemoryPaletted8Image
extends MemoryByteChannelImage
implements Paletted8Image {
    private Palette palette = null;
    private int maxSampleValue = 255;
    static /* synthetic */ Class class$0;

    public MemoryPaletted8Image(int width, int height) {
        super(1, width, height);
    }

    public MemoryPaletted8Image(int width, int height, Palette palette) {
        this(width, height);
        this.setPalette(palette);
    }

    public static void checkPalette(Palette palette) {
        if (palette == null) {
            throw new IllegalArgumentException("Palette must be non-null.");
        }
        int numEntries = palette.getNumEntries();
        if (numEntries < 1 || numEntries > 256) {
            throw new IllegalArgumentException("Number of entries must be from 1..256 for a Paletted8Image; got: " + numEntries);
        }
    }

    public PixelImage createCompatibleImage(int width, int height) {
        Palette newPalette = null;
        Palette myPalette = this.getPalette();
        if (myPalette != null) {
            newPalette = (Palette)myPalette.clone();
        }
        return new MemoryPaletted8Image(width, height, newPalette);
    }

    public long getAllocatedMemory() {
        long result = super.getAllocatedMemory();
        Palette myPalette = this.getPalette();
        if (myPalette != null) {
            result += myPalette.getAllocatedMemory();
        }
        return result;
    }

    public Class getImageType() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.jiu.data.Paletted8Image");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public int getMaxSample(int channel) {
        return this.maxSampleValue;
    }

    public Palette getPalette() {
        return this.palette;
    }

    public String getTypeDescription() {
        return "Paletted image, 8 bits per pixel";
    }

    public void setPalette(Palette palette) {
        if (palette != null && palette.getNumEntries() > 256) {
            throw new IllegalArgumentException("Cannot use palette with more than 256 entries in a Paletted8Image.");
        }
        this.palette = palette;
        this.maxSampleValue = palette == null ? 255 : palette.getNumEntries() - 1;
    }
}

