/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.quantization;

import java.util.Hashtable;
import java.util.Vector;
import net.sourceforge.jiu.codecs.BMPCodec;
import net.sourceforge.jiu.codecs.CodecMode;
import net.sourceforge.jiu.codecs.ImageLoader;
import net.sourceforge.jiu.color.analysis.MatrixCreator;
import net.sourceforge.jiu.color.analysis.MeanDifference;
import net.sourceforge.jiu.color.data.CoOccurrenceFrequencyMatrix;
import net.sourceforge.jiu.color.data.CoOccurrenceMatrix;
import net.sourceforge.jiu.color.quantization.ContouringColorPair;
import net.sourceforge.jiu.color.quantization.MedianCutNode;
import net.sourceforge.jiu.color.quantization.MedianCutQuantizer;
import net.sourceforge.jiu.color.quantization.RGBColor;
import net.sourceforge.jiu.data.Palette;
import net.sourceforge.jiu.data.Paletted8Image;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.data.RGB24Image;
import net.sourceforge.jiu.ops.ImageToImageOperation;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.OperationFailedException;
import net.sourceforge.jiu.ops.WrongParameterException;
import net.sourceforge.jiu.util.Sort;
import net.sourceforge.jiu.util.Statistics;

public class MedianCutContourRemoval
extends ImageToImageOperation {
    public static final double DEFAULT_TAU = 12.0;
    public static final int DEFAULT_NUM_PASSES = 8;
    private Vector compressibleNodes;
    private Vector contouringPairs;
    private MedianCutNode[] leaves;
    private double[] meanC;
    private double meanS;
    private int numPasses = 8;
    private Palette palette;
    private MedianCutQuantizer quantizer;
    private double stdDevS;
    private double[] stdDevC;
    private double sumMeanStdDevS;
    private double tau = 12.0;

    private double computeDistance(int index1, int index2) {
        return RGBColor.computeDistance(this.palette.getSample(0, index1), this.palette.getSample(1, index1), this.palette.getSample(2, index1), this.palette.getSample(0, index2), this.palette.getSample(1, index2), this.palette.getSample(2, index2));
    }

    private void computeStatistics(CoOccurrenceFrequencyMatrix matrix) {
        int N = this.quantizer.getPaletteSize();
        double[] values = new double[N];
        int i = 0;
        while (i < N) {
            values[i] = matrix.getValue(i, i);
            ++i;
        }
        this.meanS = Statistics.computeMean(values);
        this.stdDevS = Statistics.computeStandardDeviation(values, this.meanS);
        this.sumMeanStdDevS = this.meanS + this.stdDevS;
        this.meanC = new double[N];
        this.stdDevC = new double[N];
        int j = 0;
        while (j < N) {
            int i2 = 0;
            while (i2 < N) {
                values[i2] = matrix.getValue(i2, j);
                ++i2;
            }
            this.meanC[j] = Statistics.computeMean(values);
            this.stdDevC[j] = Statistics.computeStandardDeviation(values, this.meanC[j]);
            ++j;
        }
    }

    private Vector createContouringIndexList() {
        Hashtable<Integer, Integer> table = new Hashtable<Integer, Integer>(this.contouringPairs.size() * 2);
        Vector<Integer> indexes = new Vector<Integer>();
        Object[] contouringPairArray = this.toArray(this.contouringPairs);
        Sort.sort(contouringPairArray, new ContouringColorPair());
        int i = contouringPairArray.length - 1;
        while (i >= 0) {
            ContouringColorPair pair = (ContouringColorPair)contouringPairArray[i];
            Integer index = new Integer(pair.getColorIndex(false));
            if (table.get(index) == null) {
                table.put(index, index);
                indexes.addElement(index);
            }
            if (table.get(index = new Integer(pair.getColorIndex(true))) == null) {
                table.put(index, index);
                indexes.addElement(index);
            }
            --i;
        }
        return indexes;
    }

    private void findColorPairs(CoOccurrenceFrequencyMatrix matrix, CoOccurrenceMatrix A) {
        this.compressibleNodes = new Vector();
        this.contouringPairs = new Vector();
        int N = this.quantizer.getPaletteSize();
        int i = 0;
        while (i < N) {
            double SI = matrix.getValue(i);
            int j = i + 1;
            while (j < N) {
                MedianCutNode parentJ;
                MedianCutNode parentI;
                double SJ = matrix.getValue(j);
                if (SI > this.sumMeanStdDevS && SJ > this.sumMeanStdDevS) {
                    if (matrix.getValue(i, j) > this.meanC[j] + this.stdDevC[j] && matrix.getValue(j, i) > this.meanC[i] + this.stdDevC[i] && this.computeDistance(i, j) <= this.tau) {
                        this.contouringPairs.addElement(new ContouringColorPair(i, j, SI, SJ));
                    }
                } else if (SI < this.meanS && SJ < this.meanS && (parentI = this.leaves[i].getParentNode()) == (parentJ = this.leaves[j].getParentNode()) && A.getValue(i, j) == 0 && parentI.getNumColors() > 1) {
                    System.out.println("compressible: " + i + "/" + j);
                    this.compressibleNodes.addElement(parentI);
                }
                ++j;
            }
            ++i;
        }
    }

    public static void main(String[] args) throws Exception {
        PixelImage inputImage = ImageLoader.load(args[0]);
        if (inputImage == null) {
            System.err.println("Could not load image from " + args[0]);
            return;
        }
        MedianCutQuantizer quantizer = new MedianCutQuantizer();
        quantizer.setPaletteSize(256);
        MedianCutContourRemoval removal = new MedianCutContourRemoval();
        removal.setQuantizer(quantizer);
        removal.setInputImage(inputImage);
        removal.process();
        BMPCodec codec = new BMPCodec();
        codec.setImage(removal.getOutputImage());
        codec.setFile(args[1], CodecMode.SAVE);
        codec.process();
        codec.close();
        MeanDifference diff = new MeanDifference();
        diff.setImages(inputImage, removal.getOutputImage());
        diff.process();
        System.out.println("Mean difference: " + diff.getDifference());
    }

    private void mergeAndSplit() {
        Vector contouringIndexes = this.createContouringIndexList();
        int ITERATIONS = Math.min(contouringIndexes.size(), this.compressibleNodes.size());
        int index = 0;
        do {
            MedianCutNode compressibleNode = (MedianCutNode)this.compressibleNodes.elementAt(index);
            compressibleNode.setSuccessors(null, null);
            Integer contouringIndex = (Integer)contouringIndexes.elementAt(index);
            MedianCutNode contouringNode = this.leaves[contouringIndex];
            this.quantizer.splitNode(contouringNode);
        } while (++index < ITERATIONS);
    }

    public void process() throws MissingParameterException, OperationFailedException, WrongParameterException {
        if (this.quantizer == null) {
            throw new MissingParameterException("No MedianCutQuantizer object was specified.");
        }
        this.ensureInputImageIsAvailable();
        PixelImage pixelImage = this.getInputImage();
        if (!(pixelImage instanceof RGB24Image)) {
            throw new WrongParameterException("Input image must implement RGB24Image.");
        }
        RGB24Image originalImage = (RGB24Image)pixelImage;
        this.quantizer.setInputImage(originalImage);
        this.quantizer.setMapping(true);
        this.quantizer.setTruecolorOutput(false);
        this.quantizer.process();
        int currentPass = 0;
        while (currentPass < this.numPasses) {
            Paletted8Image palImage = (Paletted8Image)this.quantizer.getOutputImage();
            this.palette = palImage.getPalette();
            CoOccurrenceMatrix com = MatrixCreator.createCoOccurrenceMatrix(palImage);
            CoOccurrenceFrequencyMatrix cofm = MatrixCreator.createCoOccurrenceFrequencyMatrix(com);
            this.computeStatistics(cofm);
            this.leaves = this.quantizer.createLeafList();
            this.findColorPairs(cofm, com);
            if (this.compressibleNodes.size() == 0 || this.contouringPairs.size() == 0) break;
            System.out.println(String.valueOf(currentPass + 1) + " " + this.compressibleNodes.size() + " " + this.contouringPairs.size());
            this.mergeAndSplit();
            this.quantizer.setAllPaletteIndexValues();
            this.quantizer.findAllRepresentativeColors();
            this.palette = this.quantizer.createPalette();
            Paletted8Image out = (Paletted8Image)this.quantizer.getOutputImage();
            out.setPalette(this.palette);
            this.quantizer.mapImage(originalImage, out);
            ++currentPass;
        }
        this.setOutputImage(this.quantizer.getOutputImage());
    }

    public void setQuantizer(MedianCutQuantizer medianCutQuantizer) {
        this.quantizer = medianCutQuantizer;
    }

    public void setNumPasses(int newValue) {
        if (newValue < 1) {
            throw new IllegalArgumentException("Number of passes must be 1 or larger.");
        }
        this.numPasses = newValue;
    }

    public void setTau(double newValue) {
        if (newValue < 0.0) {
            throw new IllegalArgumentException("Tau value must be 0.0 or larger.");
        }
        this.tau = newValue;
    }

    private Object[] toArray(Vector list) {
        Object[] result = new Object[list.size()];
        int i = 0;
        while (i < list.size()) {
            result[i] = list.elementAt(i);
            ++i;
        }
        return result;
    }
}

