/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.promotion;

import net.sourceforge.jiu.data.BilevelImage;
import net.sourceforge.jiu.data.Gray16Image;
import net.sourceforge.jiu.data.Gray8Image;
import net.sourceforge.jiu.data.MemoryGray16Image;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.ops.ImageToImageOperation;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.WrongParameterException;

public class PromotionGray16
extends ImageToImageOperation {
    private void prepare(PixelImage in) throws MissingParameterException, WrongParameterException {
        if (in == null) {
            throw new MissingParameterException("Missing input image.");
        }
        if (!(in instanceof BilevelImage) && !(in instanceof Gray8Image)) {
            throw new WrongParameterException("Unsupported input image type: " + in.getClass().getName());
        }
        PixelImage out = this.getOutputImage();
        if (out == null) {
            this.setOutputImage(new MemoryGray16Image(in.getWidth(), in.getHeight()));
        } else {
            if (!(out instanceof Gray16Image)) {
                throw new WrongParameterException("Specified output image type must be of class Gray16Image; got " + in.getClass().getName());
            }
            if (in.getWidth() != out.getWidth()) {
                throw new WrongParameterException("Specified output image must have same width as input image.");
            }
            if (in.getHeight() != out.getHeight()) {
                throw new WrongParameterException("Specified output image must have same height as input image.");
            }
        }
    }

    private void process(BilevelImage in, Gray16Image out) {
        int WIDTH = in.getWidth();
        int HEIGHT = in.getHeight();
        short MAX = (short)out.getMaxSample(0);
        boolean MIN = false;
        int y = 0;
        while (y < HEIGHT) {
            int x = 0;
            while (x < WIDTH) {
                if (in.isBlack(x, y)) {
                    out.putShortSample(0, x, y, (short)0);
                } else {
                    out.putShortSample(0, x, y, MAX);
                }
                ++x;
            }
            this.setProgress(y, HEIGHT);
            ++y;
        }
    }

    private void process(Gray8Image in, Gray16Image out) {
        int WIDTH = in.getWidth();
        int HEIGHT = in.getHeight();
        int y = 0;
        while (y < HEIGHT) {
            int x = 0;
            while (x < WIDTH) {
                int sample = in.getSample(x, y);
                out.putSample(x, y, sample | sample << 8);
                ++x;
            }
            this.setProgress(y, HEIGHT);
            ++y;
        }
    }

    public void process() throws MissingParameterException, WrongParameterException {
        PixelImage in = this.getInputImage();
        this.prepare(in);
        Gray16Image out = (Gray16Image)this.getOutputImage();
        if (in instanceof BilevelImage) {
            this.process((BilevelImage)in, out);
        } else if (in instanceof Gray8Image) {
            this.process((Gray8Image)in, out);
        }
    }
}

