/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.data;

import net.sourceforge.jiu.color.data.CoOccurrenceFrequencyMatrix;

public abstract class BaseCoOccurrenceFrequencyMatrix
implements CoOccurrenceFrequencyMatrix {
    private double[] cofMean;
    private double[] cofStddev;
    private double scofMean;
    private double scofStddev;
    private double scofSum;

    private void computeCoOccurrenceFrequencyMeanValues() {
        this.cofMean = new double[this.getDimension()];
        int j = 0;
        while (j < this.getDimension()) {
            double result = 0.0;
            int i = 0;
            while (i < this.getDimension()) {
                result += this.getValue(i, j);
                ++i;
            }
            this.cofMean[j] = result / (double)this.getDimension();
            ++j;
        }
    }

    private void computeCoOccurrenceFrequencyStandardDeviationValues() {
        this.cofStddev = new double[this.getDimension()];
        int j = 0;
        while (j < this.getDimension()) {
            double result = 0.0;
            int i = 0;
            while (i < this.getDimension()) {
                double value = this.getValue(i, j) - this.cofMean[j];
                result += value * value;
                ++i;
            }
            this.cofStddev[j] = Math.sqrt(result);
            ++j;
        }
    }

    private void computeSelfCoOccurrenceFrequencyMeanValue() {
        double sum = 0.0;
        int i = 0;
        while (i < this.getDimension()) {
            sum += this.getValue(i, i);
            ++i;
        }
        this.scofMean = sum / (double)this.getDimension();
    }

    private void computeSelfCoOccurrenceFrequencyStandardDeviationValue() {
        double result = 0.0;
        int i = 0;
        while (i < this.getDimension()) {
            double value = this.getValue(i, i) - this.getScofMean();
            result += value * value;
            ++i;
        }
        this.scofStddev = Math.sqrt(result);
    }

    public void computeStatistics() {
        this.computeSelfCoOccurrenceFrequencyMeanValue();
        this.computeSelfCoOccurrenceFrequencyStandardDeviationValue();
        this.scofSum = this.getScofMean() + this.getScofStddev();
        this.computeCoOccurrenceFrequencyMeanValues();
        this.computeCoOccurrenceFrequencyStandardDeviationValues();
    }

    public double getMean(int index) {
        return this.cofMean[index];
    }

    public double getStddev(int index) {
        return this.cofStddev[index];
    }

    public double getScofMean() {
        return this.scofMean;
    }

    public double getScofStddev() {
        return this.scofStddev;
    }

    public double getScofSum() {
        return this.scofSum;
    }
}

