/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.conversion;

public class CMYKConversion {
    private CMYKConversion() {
    }

    private static int convertToByte(int value) {
        if (value <= 0) {
            return 0;
        }
        if (value >= 255) {
            return 255;
        }
        return value;
    }

    public static void convertCMYK32ToRGB24(int cyan, int magenta, int yellow, int black, int[] rgb) {
        int red = 255 - cyan;
        int green = 255 - magenta;
        int blue = 255 - yellow;
        rgb[0] = CMYKConversion.convertToByte(red -= black);
        rgb[1] = CMYKConversion.convertToByte(green -= black);
        rgb[2] = CMYKConversion.convertToByte(blue -= black);
    }

    public static void convertCMYK32InterleavedToRGB24Planar(byte[] cmyk, int cmykOffset, byte[] red, int redOffset, byte[] green, int greenOffset, byte[] blue, int blueOffset, int numPixels) {
        int[] rgb = new int[3];
        while (numPixels-- != 0) {
            CMYKConversion.convertCMYK32ToRGB24(cmyk[cmykOffset] & 0xFF, cmyk[cmykOffset + 1] & 0xFF, cmyk[cmykOffset + 2] & 0xFF, cmyk[cmykOffset + 3] & 0xFF, rgb);
            cmykOffset += 4;
            red[redOffset++] = (byte)rgb[0];
            green[greenOffset++] = (byte)rgb[1];
            blue[blueOffset++] = (byte)rgb[2];
        }
    }

    public static void convertCMYK32PlanarToRGB24Planar(byte[] cyan, int cyanOffset, byte[] magenta, int magentaOffset, byte[] yellow, int yellowOffset, byte[] black, int blackOffset, byte[] red, int redOffset, byte[] green, int greenOffset, byte[] blue, int blueOffset, int numPixels) {
        int[] rgb = new int[3];
        while (numPixels-- != 0) {
            CMYKConversion.convertCMYK32ToRGB24(cyan[cyanOffset++] & 0xFF, magenta[magentaOffset++] & 0xFF, yellow[yellowOffset++] & 0xFF, black[blackOffset++] & 0xFF, rgb);
            red[redOffset++] = (byte)rgb[0];
            green[greenOffset++] = (byte)rgb[1];
            blue[blueOffset++] = (byte)rgb[2];
        }
    }
}

