/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.analysis;

import net.sourceforge.jiu.color.data.CoOccurrenceFrequencyMatrix;
import net.sourceforge.jiu.color.data.CoOccurrenceMatrix;
import net.sourceforge.jiu.color.data.MemoryCoOccurrenceFrequencyMatrix;
import net.sourceforge.jiu.color.data.MemoryCoOccurrenceMatrix;
import net.sourceforge.jiu.data.Gray8Image;
import net.sourceforge.jiu.data.IntegerImage;
import net.sourceforge.jiu.data.Paletted8Image;

public class MatrixCreator {
    private MatrixCreator() {
    }

    public static CoOccurrenceMatrix createCoOccurrenceMatrix(Gray8Image image) {
        return MatrixCreator.createCoOccurrenceMatrix(image, 0);
    }

    public static CoOccurrenceMatrix createCoOccurrenceMatrix(Paletted8Image image) {
        return MatrixCreator.createCoOccurrenceMatrix(image, 0);
    }

    public static CoOccurrenceMatrix createCoOccurrenceMatrix(IntegerImage image, int channelIndex) {
        if (image == null) {
            throw new IllegalArgumentException("The image must non-null.");
        }
        if (channelIndex < 0) {
            throw new IllegalArgumentException("The channel index must be zero or larger.");
        }
        if (channelIndex >= image.getNumChannels()) {
            throw new IllegalArgumentException("The channel index must be smaller than the number of channels in the image (" + image.getNumChannels() + ").");
        }
        int dim = image.getMaxSample(channelIndex) + 1;
        MemoryCoOccurrenceMatrix matrix = new MemoryCoOccurrenceMatrix(dim);
        MatrixCreator.initCoOccurrenceMatrix(image, channelIndex, matrix);
        return matrix;
    }

    public static void initCoOccurrenceMatrix(IntegerImage image, int channelIndex, CoOccurrenceMatrix matrix) {
        if (image == null) {
            throw new IllegalArgumentException("The image must non-null.");
        }
        if (channelIndex < 0) {
            throw new IllegalArgumentException("The channel index must be zero or larger.");
        }
        if (channelIndex >= image.getNumChannels()) {
            throw new IllegalArgumentException("The channel index must be smaller than the number of channels in the image (" + image.getNumChannels() + ").");
        }
        int dim = image.getMaxSample(channelIndex) + 1;
        if (matrix == null) {
            throw new IllegalArgumentException("The matrix must non-null.");
        }
        if (matrix.getDimension() != dim) {
            throw new IllegalArgumentException("Dimension of matrix (" + matrix.getDimension() + " must be exactly one larger than " + "maximum sample value (" + (dim - 1) + ").");
        }
        matrix.clear();
        int maxX = image.getWidth() - 1;
        int maxY = image.getHeight() - 1;
        int y = 0;
        while (y <= maxY) {
            int x = 0;
            while (x <= maxX) {
                int index = image.getSample(channelIndex, x, y);
                if (x > 0) {
                    int leftNeighbor = image.getSample(channelIndex, x - 1, y);
                    matrix.incValue(index, leftNeighbor);
                }
                if (x < maxX) {
                    int rightNeighbor = image.getSample(channelIndex, x + 1, y);
                    matrix.incValue(index, rightNeighbor);
                }
                if (y > 0) {
                    int topNeighbor = image.getSample(channelIndex, x, y - 1);
                    matrix.incValue(index, topNeighbor);
                }
                if (y < maxY) {
                    int bottomNeighbor = image.getSample(channelIndex, x, y + 1);
                    matrix.incValue(index, bottomNeighbor);
                }
                ++x;
            }
            ++y;
        }
    }

    public static CoOccurrenceFrequencyMatrix createCoOccurrenceFrequencyMatrix(CoOccurrenceMatrix A) {
        if (A == null) {
            throw new IllegalArgumentException("Matrix argument must be non-null.");
        }
        int dimension = A.getDimension();
        MemoryCoOccurrenceFrequencyMatrix matrix = new MemoryCoOccurrenceFrequencyMatrix(dimension);
        MatrixCreator.initCoOccurrenceFrequencyMatrix(A, matrix);
        return matrix;
    }

    public static void initCoOccurrenceFrequencyMatrix(CoOccurrenceMatrix A, CoOccurrenceFrequencyMatrix cofm) {
        if (A == null) {
            throw new IllegalArgumentException("Co-occurrence matrix A argument must not be null.");
        }
        if (cofm == null) {
            throw new IllegalArgumentException("Co-occurrence frequency matrix cofm argument must not be null.");
        }
        int DIMENSION = A.getDimension();
        if (DIMENSION != cofm.getDimension()) {
            throw new IllegalArgumentException("Dimension of matrices A (" + DIMENSION + ") and cofm (" + cofm.getDimension() + ") must " + "be equal.");
        }
        cofm.clear();
        double totalSum = 0.0;
        int i = 0;
        while (i < DIMENSION) {
            double sum = 0.0;
            int k = 0;
            while (k < DIMENSION) {
                sum += (double)A.getValue(i, k);
                ++k;
            }
            totalSum += sum;
            int j = 0;
            while (j < DIMENSION) {
                double value = A.getValue(i, j);
                double result = sum == 0.0 ? 0.0 : value / sum;
                cofm.setValue(i, j, result);
                ++j;
            }
            ++i;
        }
        cofm.computeStatistics();
    }
}

