/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.codecs;

import java.io.DataInput;
import java.io.IOException;
import net.sourceforge.jiu.codecs.CodecMode;
import net.sourceforge.jiu.codecs.ImageCodec;
import net.sourceforge.jiu.codecs.InvalidFileStructureException;
import net.sourceforge.jiu.codecs.UnsupportedTypeException;
import net.sourceforge.jiu.codecs.WrongFileFormatException;
import net.sourceforge.jiu.data.MemoryByteChannelImage;
import net.sourceforge.jiu.data.MemoryPaletted8Image;
import net.sourceforge.jiu.data.MemoryRGB24Image;
import net.sourceforge.jiu.data.Palette;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.OperationFailedException;
import net.sourceforge.jiu.ops.WrongParameterException;

public class IFFCodec
extends ImageCodec {
    private static final int MAGIC_BMHD = 1112361028;
    private static final int MAGIC_BODY = 1112491097;
    private static final int MAGIC_CMAP = 1129136464;
    private static final int MAGIC_CAMG = 1128353095;
    private static final int MAGIC_FORM = 1179603533;
    private static final int MAGIC_ILBM = 1229734477;
    private static final int MAGIC_PBM = 1346522400;
    private static final int SIZE_BMHD = 20;
    private static final byte COMPRESSION_NONE = 0;
    private static final byte COMPRESSION_RLE = 1;
    private int camg;
    private byte compression;
    private boolean ehb;
    private boolean ham;
    private boolean ham6;
    private boolean ham8;
    private int height;
    private int numPlanes;
    private Palette palette;
    private boolean rgb24;
    private int type;
    private int width;

    private void checkAndLoad() throws InvalidFileStructureException, IOException, MissingParameterException, UnsupportedTypeException, WrongFileFormatException, WrongParameterException {
        DataInput in = this.getInputAsDataInput();
        if (in == null) {
            throw new MissingParameterException("InputStream / DataInput object is missing.");
        }
        int formMagic = in.readInt();
        if (formMagic != 1179603533) {
            throw new WrongFileFormatException("Cannot load image. The input stream is not a valid IFF file (wrong magic byte sequence).");
        }
        in.readInt();
        this.type = in.readInt();
        if (this.type != 1229734477 && this.type != 1346522400) {
            throw new UnsupportedTypeException("Cannot load image. The input stream is an IFF file, but not of type ILBM or PBM (" + IFFCodec.getChunkName(this.type) + ")");
        }
        PixelImage result = null;
        boolean hasBMHD = false;
        boolean hasCAMG = false;
        block6: do {
            int magic = in.readInt();
            int size = in.readInt();
            if ((size & 1) == 1) {
                ++size;
            }
            switch (magic) {
                case 1112361028: {
                    if (hasBMHD) {
                        throw new InvalidFileStructureException("Error in IFF file: more than one BMHD chunk.");
                    }
                    if (size != 20) {
                        throw new InvalidFileStructureException("Cannot load image. The bitmap header chunk does not have the expected size.");
                    }
                    this.width = in.readShort();
                    this.height = in.readShort();
                    if (this.width < 1 || this.height < 1) {
                        throw new InvalidFileStructureException("Cannot load image. The IFF file's bitmap header contains invalid width and height values: " + this.width + ", " + this.height);
                    }
                    in.skipBytes(4);
                    this.numPlanes = in.readByte();
                    if (this.numPlanes != 24 && (this.numPlanes < 1 || this.numPlanes > 8)) {
                        throw new UnsupportedTypeException("Cannot load image, unsupported number of bits per pixel: " + this.numPlanes);
                    }
                    in.readByte();
                    this.compression = in.readByte();
                    if (this.compression != 0 && this.compression != 1) {
                        throw new UnsupportedTypeException("Cannot load image, unsupported compression type: " + this.compression);
                    }
                    in.skipBytes(9);
                    hasBMHD = true;
                    break;
                }
                case 1112491097: {
                    if (!hasBMHD) {
                        throw new InvalidFileStructureException("Cannot load image. Error in IFF input stream: No bitmap header chunk encountered before image body chunk.");
                    }
                    if (this.palette == null && !this.rgb24) {
                        throw new InvalidFileStructureException("Cannot load image. Error in IFF input stream: No colormap chunk encountered before image body chunk.");
                    }
                    result = this.loadImage(in);
                    break;
                }
                case 1128353095: {
                    if (hasCAMG) {
                        throw new InvalidFileStructureException("Cannot load image. Error in IFF input stream: More than one CAMG chunk.");
                    }
                    hasCAMG = true;
                    if (size < 4) {
                        throw new InvalidFileStructureException("Cannot load image. CAMG must be at least four bytes large; found: " + size);
                    }
                    this.camg = in.readInt();
                    this.ham = (this.camg & 0x800) != 0;
                    this.ehb = (this.camg & 0x80) != 0;
                    in.skipBytes(size - 4);
                    break;
                }
                case 1129136464: {
                    if (this.palette != null) {
                        throw new InvalidFileStructureException("Cannot load image. Error in IFF input stream: More than one palette.");
                    }
                    if (size < 3 || size % 3 != 0) {
                        throw new InvalidFileStructureException("Cannot load image. The size of the colormap is invalid: " + size);
                    }
                    int numColors = size / 3;
                    this.palette = new Palette(numColors, 255);
                    int i = 0;
                    while (i < numColors) {
                        this.palette.putSample(0, i, in.readByte() & 0xFF);
                        this.palette.putSample(1, i, in.readByte() & 0xFF);
                        this.palette.putSample(2, i, in.readByte() & 0xFF);
                        ++i;
                    }
                    continue block6;
                }
                default: {
                    if (in.skipBytes(size) == size) continue block6;
                    throw new IOException("Error skipping " + size + " bytes of input stream.");
                }
            }
        } while (result == null);
        this.setImage(result);
    }

    private void convertRow(byte[][] sourcePlaneData, byte[][] dest) {
        int sourceMask = 128;
        int sourceIndex = 0;
        int lastRed = 0;
        int lastGreen = 0;
        int lastBlue = 0;
        int x = 0;
        while (x < this.width) {
            int paletteIndex;
            int destMask = 1;
            int index = 0;
            int p = 0;
            while (p < sourcePlaneData.length) {
                if ((sourcePlaneData[p][sourceIndex] & sourceMask) != 0) {
                    index |= destMask;
                }
                destMask <<= 1;
                ++p;
            }
            if ((x & 7) == 7) {
                ++sourceIndex;
            }
            sourceMask = sourceMask == 1 ? 128 : (sourceMask >>= 1);
            if (this.ham6) {
                paletteIndex = index & 0xF;
                switch (index >> 4 & 3) {
                    case 0: {
                        lastRed = this.palette.getSample(0, paletteIndex);
                        lastGreen = this.palette.getSample(1, paletteIndex);
                        lastBlue = this.palette.getSample(2, paletteIndex);
                        break;
                    }
                    case 1: {
                        lastBlue = lastBlue & 0xF | paletteIndex << 4;
                        break;
                    }
                    case 2: {
                        lastRed = lastRed & 0xF | paletteIndex << 4;
                        break;
                    }
                    case 3: {
                        lastGreen = lastGreen & 0xF | paletteIndex << 4;
                    }
                }
                dest[0][x] = (byte)lastRed;
                dest[1][x] = (byte)lastGreen;
                dest[2][x] = (byte)lastBlue;
            } else if (this.ham8) {
                paletteIndex = index & 0x3F;
                switch (index >> 6 & 3) {
                    case 0: {
                        lastRed = this.palette.getSample(0, paletteIndex);
                        lastGreen = this.palette.getSample(1, paletteIndex);
                        lastBlue = this.palette.getSample(2, paletteIndex);
                        break;
                    }
                    case 1: {
                        lastBlue = lastBlue & 3 | paletteIndex << 2;
                        break;
                    }
                    case 2: {
                        lastRed = lastRed & 3 | paletteIndex << 2;
                        break;
                    }
                    case 3: {
                        lastGreen = lastGreen & 3 | paletteIndex << 2;
                    }
                }
                dest[0][x] = (byte)lastRed;
                dest[1][x] = (byte)lastGreen;
                dest[2][x] = (byte)lastBlue;
            } else if (this.rgb24) {
                dest[2][x] = (byte)(index >> 16);
                dest[1][x] = (byte)(index >> 8);
                dest[0][x] = (byte)index;
            } else {
                dest[0][x] = (byte)index;
            }
            ++x;
        }
    }

    private void createExtraHalfbritePalette() {
        if (this.palette == null) {
            return;
        }
        int numPaletteEntries = this.palette.getNumEntries();
        Palette tempPalette = new Palette(numPaletteEntries * 2, 255);
        int i = 0;
        while (i < numPaletteEntries) {
            int red = this.palette.getSample(0, i);
            tempPalette.putSample(0, numPaletteEntries + i, red);
            tempPalette.putSample(0, i, red / 2 & 0xF0);
            int green = this.palette.getSample(1, i);
            tempPalette.putSample(1, numPaletteEntries + i, red);
            tempPalette.putSample(1, i, green / 2 & 0xF0);
            int blue = this.palette.getSample(2, i);
            tempPalette.putSample(2, numPaletteEntries + i, blue);
            tempPalette.putSample(2, i, blue / 2 & 0xF0);
            ++i;
        }
        this.palette = tempPalette;
    }

    private static String getChunkName(int name) {
        StringBuffer sb = new StringBuffer(4);
        sb.setLength(4);
        sb.setCharAt(0, (char)(name >> 24 & 0xFF));
        sb.setCharAt(1, (char)(name >> 16 & 0xFF));
        sb.setCharAt(2, (char)(name >> 8 & 0xFF));
        sb.setCharAt(3, (char)(name & 0xFF));
        return new String(sb);
    }

    public String[] getFileExtensions() {
        return new String[]{".lbm", ".iff"};
    }

    public String getFormatName() {
        return "Amiga Interchange File Format (IFF, LBM)";
    }

    public String[] getMimeTypes() {
        return new String[]{"image/x-iff"};
    }

    public boolean isLoadingSupported() {
        return true;
    }

    public boolean isSavingSupported() {
        return false;
    }

    private void loadBytes(DataInput in, byte[] data, int num, int y) throws InvalidFileStructureException, IOException {
        switch (this.compression) {
            case 0: {
                in.readFully(data, 0, num);
                break;
            }
            case 1: {
                int x = 0;
                while (x < num) {
                    int n = in.readByte() & 0xFF;
                    boolean compressed = false;
                    int count = -1;
                    try {
                        if (n < 128) {
                            in.readFully(data, x, ++n);
                            x += n;
                            continue;
                        }
                        if (n <= 128) continue;
                        compressed = true;
                        count = 257 - n;
                        byte value = in.readByte();
                        while (count-- > 0) {
                            data[x++] = value;
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException ioobe) {
                        throw new InvalidFileStructureException("Error: RLE-compressed image file seems to be corrupt (compressed=" + compressed + ", x=" + x + ", y=" + y + ", count=" + (compressed ? -n + 1 : n) + ", array length=" + data.length + ").");
                    }
                }
                break;
            }
            default: {
                throw new InvalidFileStructureException("Error loading image; unknown compression type (" + this.compression + ")");
            }
        }
    }

    private PixelImage loadImage(DataInput in) throws InvalidFileStructureException, IOException, UnsupportedTypeException, WrongParameterException {
        int i;
        boolean oddBytesPerRow;
        this.setBoundsIfNecessary(this.width, this.height);
        this.checkImageResolution();
        if (this.ham) {
            if (this.numPlanes == 6) {
                this.ham6 = true;
            } else if (this.numPlanes == 8) {
                this.ham8 = true;
            } else {
                throw new UnsupportedTypeException("Cannot handle IFF ILBM HAM image file with number of planes other than 6 or 8 (got " + this.numPlanes + ").");
            }
            if (this.palette == null) {
                throw new InvalidFileStructureException("Invalid IFF ILBM file: HAM (Hold And Modify) image without a palette.");
            }
            int numPaletteEntries = this.palette.getNumEntries();
            if (this.ham6 && numPaletteEntries < 16) {
                throw new InvalidFileStructureException("Invalid IFF ILBM file: HAM (Hold And Modify) 6 bit image with a number of palette entries less than 16 (" + numPaletteEntries + ").");
            }
            if (this.ham8 && numPaletteEntries < 64) {
                throw new InvalidFileStructureException("Invalid IFF ILBM file: HAM (Hold And Modify) 8 bit image with a number of palette entries less than 64 (" + numPaletteEntries + ").");
            }
        }
        if (this.ehb) {
            this.createExtraHalfbritePalette();
        }
        int numBytesPerPlane = (this.width + 7) / 8;
        MemoryByteChannelImage image = null;
        MemoryPaletted8Image palettedImage = null;
        MemoryRGB24Image rgbImage = null;
        if (this.numPlanes == 24 || this.ham) {
            image = rgbImage = new MemoryRGB24Image(this.getBoundsWidth(), this.getBoundsHeight());
        } else {
            palettedImage = new MemoryPaletted8Image(this.getBoundsWidth(), this.getBoundsHeight(), this.palette);
            image = palettedImage;
        }
        boolean bl = oddBytesPerRow = numBytesPerPlane * this.numPlanes % 2 != 0;
        if (this.type == 1346522400) {
            oddBytesPerRow = this.width % 2 == 1;
        }
        byte[][] planes = null;
        int numChannels = 1;
        if (this.type == 1229734477) {
            int allocBytes = numBytesPerPlane;
            if (numBytesPerPlane % 2 == 1) {
                ++allocBytes;
            }
            planes = new byte[this.numPlanes][];
            if (this.rgb24 || this.ham) {
                numChannels = 3;
            }
            i = 0;
            while (i < this.numPlanes) {
                planes[i] = new byte[allocBytes];
                ++i;
            }
        } else {
            planes = new byte[][]{new byte[this.width]};
        }
        byte[][] dest = new byte[numChannels][];
        i = 0;
        while (i < numChannels) {
            dest[i] = new byte[this.width];
            ++i;
        }
        int y = 0;
        int destY = 0 - this.getBoundsY1();
        while (y <= this.getBoundsY2()) {
            if (this.type == 1229734477) {
                int p = 0;
                while (p < this.numPlanes) {
                    this.loadBytes(in, planes[p], numBytesPerPlane, y);
                    ++p;
                }
            } else if (this.type == 1346522400) {
                this.loadBytes(in, planes[0], numBytesPerPlane, y);
            }
            if (this.compression == 0 && oddBytesPerRow) {
                in.readByte();
            }
            this.setProgress(y, this.getBoundsY2() + 1);
            if (this.isRowRequired(y)) {
                if (this.type == 1229734477) {
                    this.convertRow(planes, dest);
                    if (this.rgb24 || this.ham) {
                        rgbImage.putByteSamples(0, 0, destY, this.getBoundsWidth(), 1, dest[0], this.getBoundsX1());
                        rgbImage.putByteSamples(1, 0, destY, this.getBoundsWidth(), 1, dest[1], this.getBoundsX1());
                        rgbImage.putByteSamples(2, 0, destY, this.getBoundsWidth(), 1, dest[2], this.getBoundsX1());
                    } else {
                        palettedImage.putByteSamples(0, 0, destY, this.getBoundsWidth(), 1, dest[0], this.getBoundsX1());
                    }
                } else if (this.type == 1346522400) {
                    palettedImage.putByteSamples(0, 0, destY, this.getBoundsWidth(), 1, planes[0], this.getBoundsX1());
                }
            }
            ++y;
            ++destY;
        }
        return image;
    }

    public void process() throws InvalidFileStructureException, MissingParameterException, OperationFailedException, UnsupportedTypeException, WrongFileFormatException {
        this.initModeFromIOObjects();
        if (this.getMode() == CodecMode.LOAD) {
            try {
                this.checkAndLoad();
            }
            catch (IOException ioe) {
                throw new InvalidFileStructureException("I/O error while loading: " + ioe.toString());
            }
        } else {
            throw new OperationFailedException("Only loading from IFF is supported.");
        }
    }
}

