package zetablitz.zeta;

import java.util.List;
import java.util.Arrays;
import java.util.ArrayList;
import java.util.Properties;
import java.io.FileInputStream;
import java.io.FileOutputStream;

/**
 * @author ni2
 * @version 0.1, 09/02/06
 * This code licensed under the terms of the GPL.  See doc/LICENSE.
 *
 * 사용자 세션을 다루는 클래스.
 */

public class ZetaSessionManager{
	private static final ZetaSessionManager manager = new ZetaSessionManager();
	private Properties properties = new Properties();
	//세션 파일이 XML인지의 여부
	public boolean isXML = false;
	//세션 모듈 파일들
	public List<String> modules;
	
	public static ZetaSessionManager instance(){
		return manager;
	}
	
	private ZetaSessionManager(){
		load();
		modules = new ArrayList<String>();
		String s = get("modules");
		if(s != null)
			modules.addAll(Arrays.asList(s.split(Zeta.CONFIG_KEYS_SEPARATOR))); 
	}
	
	//모듈 추가. 현재 중복은 허용하지 않고 있다.
	public void addModule(String module){
		for(String m : modules){
			if(m.equals(module)) return;
		}
		modules.add(module);
	}
	
	public void removeModule(String module){
		int index = -1;
		int i=0;
		for(String m : modules){
			if(m.equals(module))
				index = i;
			i++;
		}
		if(index != -1) modules.remove(index);
	}
	
	//사용자 세션 정보를 불러온다.
	//처음 단 한 번만 실행된다.
	private void load(){
		try{
			properties = new Properties();
			FileInputStream fis = new FileInputStream(Zeta.SESSION_PATH);
			if(isXML)
				properties.loadFromXML(fis);
			else
				properties.load(fis);
			fis.close();
		}catch(Exception e){
			e.printStackTrace();
		}
	}
	
	//세션 정보를 저장한다.
	public void save(){
		//로드된 모듈들을 하나의 문자열로 결합
		StringBuilder sb = new StringBuilder();
		for(String module : modules){
			sb.append(module);
			sb.append(Zeta.CONFIG_KEYS_SEPARATOR);
		}
		set("modules", sb.toString());
		
		try{
			FileOutputStream fos = new FileOutputStream(Zeta.SESSION_PATH);
			if(isXML)
				properties.storeToXML(fos, null);
			else
				properties.store(fos, null);
			fos.close();
		}catch(Exception e){
			e.printStackTrace();
		}
	}
	
	public void set(String key, String value){
		properties.setProperty(key, value);
	}
	
	public String get(String key){
		return properties.getProperty(key);
	}
}
