package zetablitz.zeta;

import cookxml.cookswt.CookSwt;
import cookxml.cookbsh.CookBSH;

/**
 * @author ni2
 * @version 0.1, 09/01/06
 * This code licensed under the terms of the GPL.  See doc/LICENSE.
 *
 * bsh, xml, js, jy 파일을 다루는 인터프리터 컨트롤러.
 */
public class ZetaInterpreter{
	private static final ZetaInterpreter controller = new ZetaInterpreter();
	private bsh.Interpreter bsh;
	private CookSwt cookSwt;
	
	public static ZetaInterpreter instance(){
		return controller;
	}
	
	private ZetaInterpreter(){
		bsh = new bsh.Interpreter();
		
		try{
			//초기화 스크립트를 실행한다.
			bsh.source(Zeta.BSH_IMPORT_PATH);
			
		}catch(Exception e){
			e.printStackTrace();
		}
	}
	
	//실행할 스크립트를 입력받아 적절한 함수로 넘긴다.
	public void interpret(String fileName){
		Object result = null;
		if(fileName.endsWith("bsh"))
			result = interpretFromBSH(fileName);
		else if(fileName.endsWith("xml"))
			result = interpretFromXML(fileName);
		
		if(result != null)
			Zeta.openWidget(new ZetaModule(fileName, result));
	}
	
	//파일로부터 bsh 스크립트를 읽어 실행한다.
	private Object interpretFromBSH(String fileName){
		Object result = null;
		try{
			result = bsh.source(fileName);
			if(result != null) Zeta.logger.println(result.toString());
			
		}catch(Exception e){
			Zeta.logger.printStackTrace(e);
		}
		return result;
	}
	
	//파일로부터 cookxml 스크립트를 읽어 실행한다.
	//시작 성능을 위해 cookSwt는 최초 사용 시점에 초기화된다.
	private Object interpretFromXML(String fileName){
		if(cookSwt == null){
			cookSwt = new CookSwt();
			CookBSH.setupTagLibrary (cookSwt.getSwtTagLibrary());
		}
		
		Object result = null;
		
		try{
			result = cookSwt.xmlDecode(fileName);
			
		}catch(Exception e){
			Zeta.logger.printStackTrace(e);
		}
		
		return result;
	}
	
	//입력받은 bsh 명령을 실행한다.
	public void bshInterpret(String command){
		try{
			Object result = bsh.eval(command);
			if(result != null) Zeta.logger.println(result.toString());
			
		}catch(Exception e){
			Zeta.logger.printStackTrace(e);
		}
	}
}
