/*
 * Decompiled with CFR 0.152.
 */
package cookxml.cookswt.creator;

import cookxml.cookswt.exception.BadStyleException;
import cookxml.core.DecodeEngine;
import cookxml.core.creator.Creator;
import cookxml.core.exception.CookXmlException;
import cookxml.core.exception.CreatorException;
import java.lang.reflect.Field;
import java.util.StringTokenizer;
import org.eclipse.swt.layout.GridData;
import org.w3c.dom.Element;

public class GridDataCreator
implements Creator {
    public static String STYLE_ATTR = "style";
    private static final Creator s_instance = new GridDataCreator();

    public static Creator getInstance() {
        return s_instance;
    }

    private GridDataCreator() {
    }

    public Object create(String parentTag, Element elm, Object parentObj, String value, DecodeEngine decodeEngine) throws CreatorException {
        try {
            int style = GridDataCreator.getStyle(elm, decodeEngine);
            if (style == 0) {
                return new GridData();
            }
            return new GridData(style);
        }
        catch (Exception ex) {
            throw new CreatorException(decodeEngine, (Throwable)ex, (Creator)this, parentTag, elm, parentObj, value);
        }
    }

    public Object editFinished(String parentTag, Element elm, Object parentObj, Object obj, DecodeEngine decodeEngine) throws CookXmlException {
        return obj;
    }

    public static int getStyle(Element elm, DecodeEngine decodeEngine) throws CookXmlException {
        int returnVal = 0;
        try {
            String value = elm.getAttribute(STYLE_ATTR);
            if (value == null || value.length() == 0) {
                return returnVal;
            }
            StringTokenizer tokenizer = new StringTokenizer(value, "| ");
            do {
                String tok = tokenizer.nextToken();
                Field field = (class$org$eclipse$swt$layout$GridData == null ? GridDataCreator.class$("org.eclipse.swt.layout.GridData") : class$org$eclipse$swt$layout$GridData).getField(tok);
                returnVal |= field.getInt(null);
            } while (tokenizer.hasMoreElements());
        }
        catch (Exception ex) {
            decodeEngine.handleException(null, (Exception)((Object)new BadStyleException(GridData.class, elm.getAttribute(STYLE_ATTR))));
        }
        return returnVal;
    }
}

