/*
 * Decompiled with CFR 0.152.
 */
package cookxml.cookswt.converter;

import cookxml.core.DecodeEngine;
import cookxml.core.converter.Converter;
import cookxml.core.exception.ConverterException;
import java.lang.reflect.Field;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public class ColorConverter
implements Converter {
    private static final Converter s_instance = new ColorConverter();

    public static Converter getInstance() {
        return s_instance;
    }

    private ColorConverter() {
    }

    public Object convert(String value, DecodeEngine decodeEngine) throws ConverterException {
        Color color = ColorConverter.getColor(value);
        if (color != null) {
            return color;
        }
        throw new ConverterException(decodeEngine, null, (Converter)this, value);
    }

    public static Color getColor(String value) {
        try {
            Field colorField;
            String colorName = value.toUpperCase();
            if (colorName.indexOf("COLOR_") != 0) {
                colorName = "COLOR_" + value;
            }
            if ((colorField = SWT.class.getField(colorName)) != null) {
                int id = colorField.getInt(null);
                return Display.getCurrent().getSystemColor(id);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        String colorVal = value;
        if (colorVal.startsWith("#")) {
            colorVal = colorVal.substring(1);
        }
        try {
            int hexVal = Integer.parseInt(colorVal, 16);
            return new Color((Device)Display.getCurrent(), hexVal >> 16 & 0xFF, hexVal >> 8 & 0xFF, hexVal & 0xFF);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

