/*
 * Decompiled with CFR 0.152.
 */
package cookxml.core.util;

import cookxml.core.CookXml;
import cookxml.core.DecodeEngine;
import cookxml.core.util.DocumentElement;
import java.io.File;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IncludeUtils {
    public static DocumentElement getElement(String includeStr, DecodeEngine decodeEngine) throws Exception {
        return IncludeUtils.getElement(includeStr, decodeEngine.getCookXml().getClassLoader(), decodeEngine.getDocument(), decodeEngine.getCookXml().getDocumentBuilder());
    }

    public static DocumentElement getElement(String includeStr, Document docRoot, DocumentBuilder builder) throws Exception {
        return IncludeUtils.getElement(includeStr, CookXml.getDefaultClassLoader(), docRoot, builder);
    }

    public static DocumentElement getElement(String includeStr, ClassLoader classLoader, Document docRoot, DocumentBuilder builder) throws Exception {
        Document doc;
        if (includeStr == null || includeStr.length() == 0) {
            return null;
        }
        String id = null;
        int idPos = includeStr.lastIndexOf("#");
        if (idPos >= 0) {
            id = includeStr.substring(idPos + 1);
            includeStr = includeStr.substring(0, idPos);
        }
        if (includeStr.length() == 0) {
            doc = docRoot;
        } else {
            InputStream inputStream = classLoader.getResourceAsStream(includeStr);
            if (inputStream == null) {
                try {
                    doc = builder.parse(new File(includeStr));
                }
                catch (Exception ex) {
                    doc = builder.parse(includeStr);
                }
            } else {
                doc = builder.parse(inputStream);
            }
        }
        if (doc == null) {
            return null;
        }
        if (id == null || id.length() == 0) {
            return new DocumentElement(doc, doc.getDocumentElement());
        }
        return new DocumentElement(doc, IncludeUtils.getElementById(doc.getDocumentElement(), id));
    }

    public static Element getElementById(Element rootElm, String id) {
        if (id.equals(rootElm.getAttribute("id"))) {
            return rootElm;
        }
        NodeList childNodes = rootElm.getChildNodes();
        int size = childNodes.getLength();
        for (int i = 0; i < size; ++i) {
            Element elm;
            Node node = childNodes.item(i);
            if (!(node instanceof Element) || (elm = IncludeUtils.getElementById((Element)node, id)) == null) continue;
            return elm;
        }
        return null;
    }
}

