/*
 * Decompiled with CFR 0.152.
 */
package cookxml.core.setter;

import cookxml.core.DecodeEngine;
import cookxml.core.exception.SetterException;
import cookxml.core.setter.DefaultSetter;
import cookxml.core.setter.Setter;
import java.lang.reflect.Field;

public class ConstantSetter
implements Setter {
    private Class m_constantClass;
    private Setter m_setter;

    public ConstantSetter(Class constantClass) {
        this(constantClass, DefaultSetter.getInstance());
    }

    public ConstantSetter(Class constantClass, Setter setter) {
        this.m_constantClass = constantClass;
        this.m_setter = setter;
    }

    public void setAttribute(String tag, String attr, Object obj, Object value, DecodeEngine decodeEngine) throws SetterException {
        if (!(value instanceof String)) {
            return;
        }
        String str = (String)value;
        if (str == null || str.length() == 0) {
            return;
        }
        boolean hasField = false;
        Object constVal = null;
        try {
            Field field = this.m_constantClass.getField(str);
            constVal = field.get(null);
            hasField = true;
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (hasField) {
            this.m_setter.setAttribute(tag, attr, obj, constVal, decodeEngine);
        } else {
            DefaultSetter.getInstance().setAttribute(tag, attr, obj, value, decodeEngine);
        }
    }
}

