/*
 * Decompiled with CFR 0.152.
 */
package cookxml.core;

import cookxml.core.DecodeEngine;
import cookxml.core.Handler;
import cookxml.core.converter.Converter;
import cookxml.core.exception.FunctionHandlerException;
import cookxml.core.exception.HandlerException;
import cookxml.core.util.ClassUtils;
import java.lang.reflect.Method;

public class FunctionHandler
implements Handler {
    private final Method m_method;

    private FunctionHandler(Method method) {
        this.m_method = method;
    }

    public boolean invoke(Object obj, Object value, DecodeEngine decodeEngine) throws HandlerException {
        try {
            Converter converter;
            Class<?> valueClass;
            Method method = this.m_method;
            if (value == null) {
                method.invoke(obj, new Object[]{null});
                return true;
            }
            Class targetClass = ClassUtils.getEquivalentClass(method.getParameterTypes()[0]);
            if (targetClass.isAssignableFrom(valueClass = value.getClass())) {
                method.invoke(obj, value);
                return true;
            }
            if (value instanceof String && (converter = decodeEngine.getCookXml().getTagLibrary().getConverter(targetClass)) != null) {
                method.invoke(obj, converter.convert((String)value, decodeEngine));
                return true;
            }
        }
        catch (Exception ex) {
            throw new FunctionHandlerException(decodeEngine, ex, obj, value, this.m_method);
        }
        throw new FunctionHandlerException(decodeEngine, null, obj, value, this.m_method);
    }

    public Method getMethod() {
        return this.m_method;
    }

    public String toString() {
        return this.m_method.toString();
    }

    public static Handler getHandler(Object obj, String funcName, Class valueClass) {
        Method[] methods = obj.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method;
            Class<?>[] params;
            if (!methods[i].getName().equalsIgnoreCase(funcName) || (params = (method = methods[i]).getParameterTypes()).length != 1) continue;
            if (valueClass == null) {
                return new FunctionHandler(method);
            }
            Class targetClass = ClassUtils.getEquivalentClass(params[0]);
            if (!targetClass.isAssignableFrom(valueClass)) continue;
            return new FunctionHandler(method);
        }
        return null;
    }
}

