/*
 * Decompiled with CFR 0.152.
 */
package cookxml.common.setter;

import cookxml.core.DecodeEngine;
import cookxml.core.FunctionHandler;
import cookxml.core.Handler;
import cookxml.core.exception.SetterException;
import cookxml.core.setter.Setter;

public class ObjectOrHookVariableSetter
implements Setter {
    private final String m_funcName;
    private final Class m_targetClass;

    public ObjectOrHookVariableSetter(String funcName, Class targetClass) {
        this.m_funcName = funcName;
        this.m_targetClass = targetClass;
    }

    public void setAttribute(String tag, String attr, Object obj, Object value, DecodeEngine decodeEngine) throws SetterException {
        if (value == null) {
            return;
        }
        try {
            Handler handler;
            String funcName = this.m_funcName;
            Class targetClass = this.m_targetClass;
            Object fieldObj = null;
            if (value instanceof String) {
                if (!"null".equals((String)value)) {
                    fieldObj = decodeEngine.getVariable((String)value);
                    if (fieldObj == null) {
                        return;
                    }
                    if (!targetClass.isAssignableFrom(fieldObj.getClass())) {
                        return;
                    }
                }
            } else if (targetClass == null || targetClass.isInstance(value)) {
                fieldObj = value;
            }
            if ((handler = decodeEngine.getHandler(tag, funcName)) == null && (handler = FunctionHandler.getHandler(obj, funcName, targetClass)) != null) {
                decodeEngine.setHandler(tag, funcName, handler);
            }
            if (handler != null) {
                handler.invoke(obj, fieldObj, decodeEngine);
                return;
            }
        }
        catch (Exception ex) {
            throw new SetterException(decodeEngine, ex, this, tag, attr, obj, value);
        }
        throw new SetterException(decodeEngine, null, this, tag, attr, obj, value);
    }
}

