/*
 * Decompiled with CFR 0.152.
 */
package cookxml.common.adder;

import cookxml.common.InheritableTagLibrary;
import cookxml.core.DecodeEngine;
import cookxml.core.TagLibrary;
import cookxml.core.adder.Adder;
import cookxml.core.exception.AdderException;
import java.util.Iterator;
import java.util.LinkedList;

public class InheritAdder
implements Adder {
    private static final Adder s_instance = new InheritAdder();

    public static Adder getInstance() {
        return s_instance;
    }

    private InheritAdder() {
    }

    public boolean add(String parentTag, Object parent, Object child, DecodeEngine decodeEngine) throws AdderException {
        TagLibrary tagLibrary = decodeEngine.getCookXml().getTagLibrary();
        if (!(tagLibrary instanceof InheritableTagLibrary)) {
            return false;
        }
        InheritableTagLibrary inheritLib = (InheritableTagLibrary)tagLibrary;
        LinkedList parentTags = inheritLib.getParentTags(parentTag);
        if (parentTags == null) {
            return false;
        }
        Iterator iter = parentTags.iterator();
        while (iter.hasNext()) {
            String tag = (String)iter.next();
            Adder adder = inheritLib.getAdder(tag);
            if (adder == null || !adder.add(tag, parent, child, decodeEngine)) continue;
            return true;
        }
        return false;
    }
}

