/*
 * Decompiled with CFR 0.152.
 */
package cookxml.cookbsh.creator;

import bsh.ExternalNameSpace;
import bsh.Interpreter;
import bsh.NameSpace;
import cookxml.common.creator.TextCreator;
import cookxml.cookbsh.CookXmlVarMap;
import cookxml.core.DecodeEngine;
import cookxml.core.creator.Creator;
import cookxml.core.exception.CookXmlException;
import cookxml.core.exception.CreatorException;
import java.util.Map;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BSHCreator
implements Creator {
    public static final String SRC_ATTR = "src";
    public static final String BSH_KEY = "bshKey";
    private static final Creator s_instance = new BSHCreator();

    public static Creator getInstance() {
        return s_instance;
    }

    private BSHCreator() {
    }

    public Object create(String parentTag, Element elm, Object parentObj, String value, DecodeEngine decodeEngine) throws CreatorException {
        try {
            String code;
            decodeEngine.setDoAdd(false);
            String src = elm.getAttribute(SRC_ATTR);
            if (src == null || src.length() == 0) {
                Node node = elm.getFirstChild();
                if (node == null || !(node instanceof CharacterData)) {
                    return null;
                }
                code = ((CharacterData)node).getData();
            } else {
                code = TextCreator.readText((String)src, (ClassLoader)decodeEngine.getCookXml().getClassLoader());
                if (code == null) {
                    return null;
                }
            }
            Interpreter inter = new Interpreter();
            inter.setNameSpace((NameSpace)new ExternalNameSpace(null, "cookxml", (Map)new CookXmlVarMap(decodeEngine.getCookXml())));
            return inter.eval(code);
        }
        catch (Exception ex) {
            throw new CreatorException(decodeEngine, (Throwable)ex, (Creator)this, parentTag, elm, parentObj, value);
        }
    }

    public Object editFinished(String parentTag, Element elm, Object parentObj, Object obj, DecodeEngine decodeEngine) throws CookXmlException {
        decodeEngine.addChild(parentTag, elm, parentObj, obj);
        return obj;
    }
}

