/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.gtk.GtkAdjustment;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ScrollBar
extends Widget {
    Scrollable parent;
    int adjustmentHandle;

    ScrollBar() {
    }

    ScrollBar(Scrollable parent, int style) {
        super(parent, ScrollBar.checkStyle(style));
        this.parent = parent;
        this.createWidget(0);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return ScrollBar.checkBits(style, 256, 512, 0, 0, 0, 0);
    }

    void deregister() {
        super.deregister();
        if (this.adjustmentHandle != 0) {
            this.display.removeWidget(this.adjustmentHandle);
        }
    }

    public boolean getEnabled() {
        this.checkWidget();
        if (this.handle != 0) {
            return OS.GTK_WIDGET_SENSITIVE(this.handle);
        }
        return true;
    }

    public int getIncrement() {
        this.checkWidget();
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove(adjustment, this.adjustmentHandle);
        return (int)adjustment.step_increment;
    }

    public int getMaximum() {
        this.checkWidget();
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove(adjustment, this.adjustmentHandle);
        return (int)adjustment.upper;
    }

    public int getMinimum() {
        this.checkWidget();
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove(adjustment, this.adjustmentHandle);
        return (int)adjustment.lower;
    }

    public int getPageIncrement() {
        this.checkWidget();
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove(adjustment, this.adjustmentHandle);
        return (int)adjustment.page_increment;
    }

    public Scrollable getParent() {
        this.checkWidget();
        return this.parent;
    }

    public int getSelection() {
        this.checkWidget();
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove(adjustment, this.adjustmentHandle);
        return (int)adjustment.value;
    }

    public Point getSize() {
        this.checkWidget();
        if (this.handle == 0) {
            return new Point(0, 0);
        }
        int cfr_ignored_0 = this.parent.scrolledHandle;
        GtkRequisition requisition = new GtkRequisition();
        OS.gtk_widget_size_request(this.handle, requisition);
        return new Point(requisition.width, requisition.height);
    }

    public int getThumb() {
        this.checkWidget();
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove(adjustment, this.adjustmentHandle);
        return (int)adjustment.page_size;
    }

    public boolean getVisible() {
        this.checkWidget();
        int scrolledHandle = this.parent.scrolledHandle;
        int[] hsp = new int[1];
        int[] vsp = new int[1];
        OS.gtk_scrolled_window_get_policy(scrolledHandle, hsp, vsp);
        if ((this.style & 0x100) != 0) {
            return hsp[0] != 2;
        }
        return vsp[0] != 2;
    }

    int gtk_value_changed(int adjustment) {
        this.postEvent(13);
        return 0;
    }

    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect(this.adjustmentHandle, OS.value_changed, this.display.windowProc2, 49);
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.getParent().getEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible() && this.getParent().isVisible();
    }

    void register() {
        super.register();
        if (this.adjustmentHandle != 0) {
            this.display.addWidget(this.adjustmentHandle, this);
        }
    }

    void releaseChild() {
        super.releaseChild();
        if (this.parent.horizontalBar == this) {
            this.parent.horizontalBar = null;
        }
        if (this.parent.verticalBar == this) {
            this.parent.verticalBar = null;
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if (this.handle != 0) {
            OS.gtk_widget_set_sensitive(this.handle, enabled);
        }
    }

    public void setIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove(adjustment, this.adjustmentHandle);
        adjustment.step_increment = value;
        OS.memmove(this.adjustmentHandle, adjustment);
        OS.g_signal_handlers_block_matched(this.adjustmentHandle, 16, 0, 0, 0, 0, 49);
        OS.gtk_adjustment_changed(this.adjustmentHandle);
        OS.g_signal_handlers_unblock_matched(this.adjustmentHandle, 16, 0, 0, 0, 0, 49);
    }

    public void setMaximum(int value) {
        this.checkWidget();
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove(adjustment, this.adjustmentHandle);
        int minimum = (int)adjustment.lower;
        if (value <= minimum) {
            return;
        }
        adjustment.upper = value;
        adjustment.page_size = Math.min((int)adjustment.page_size, value - minimum);
        adjustment.value = Math.min((int)adjustment.value, (int)((double)value - adjustment.page_size));
        OS.memmove(this.adjustmentHandle, adjustment);
        OS.g_signal_handlers_block_matched(this.adjustmentHandle, 16, 0, 0, 0, 0, 49);
        OS.gtk_adjustment_changed(this.adjustmentHandle);
        OS.g_signal_handlers_unblock_matched(this.adjustmentHandle, 16, 0, 0, 0, 0, 49);
    }

    public void setMinimum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove(adjustment, this.adjustmentHandle);
        int maximum = (int)adjustment.upper;
        if (value >= maximum) {
            return;
        }
        adjustment.lower = value;
        adjustment.page_size = Math.min((int)adjustment.page_size, maximum - value);
        adjustment.value = Math.max((int)adjustment.value, value);
        OS.memmove(this.adjustmentHandle, adjustment);
        OS.g_signal_handlers_block_matched(this.adjustmentHandle, 16, 0, 0, 0, 0, 49);
        OS.gtk_adjustment_changed(this.adjustmentHandle);
        OS.g_signal_handlers_unblock_matched(this.adjustmentHandle, 16, 0, 0, 0, 0, 49);
    }

    public void setPageIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove(adjustment, this.adjustmentHandle);
        adjustment.page_increment = value;
        OS.memmove(this.adjustmentHandle, adjustment);
        OS.g_signal_handlers_block_matched(this.adjustmentHandle, 16, 0, 0, 0, 0, 49);
        OS.gtk_adjustment_changed(this.adjustmentHandle);
        OS.g_signal_handlers_unblock_matched(this.adjustmentHandle, 16, 0, 0, 0, 0, 49);
    }

    public void setSelection(int value) {
        this.checkWidget();
        value = Math.min(value, this.getMaximum() - this.getThumb());
        OS.g_signal_handlers_block_matched(this.adjustmentHandle, 16, 0, 0, 0, 0, 49);
        OS.gtk_adjustment_set_value(this.adjustmentHandle, value);
        OS.g_signal_handlers_unblock_matched(this.adjustmentHandle, 16, 0, 0, 0, 0, 49);
    }

    public void setThumb(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove(adjustment, this.adjustmentHandle);
        value = Math.min(value, (int)(adjustment.upper - adjustment.lower));
        adjustment.page_size = value;
        adjustment.value = Math.min((int)adjustment.value, (int)(adjustment.upper - (double)value));
        OS.memmove(this.adjustmentHandle, adjustment);
        OS.g_signal_handlers_block_matched(this.adjustmentHandle, 16, 0, 0, 0, 0, 49);
        OS.gtk_adjustment_changed(this.adjustmentHandle);
        OS.g_signal_handlers_unblock_matched(this.adjustmentHandle, 16, 0, 0, 0, 0, 49);
    }

    public void setValues(int selection, int minimum, int maximum, int thumb, int increment, int pageIncrement) {
        this.checkWidget();
        if (minimum < 0) {
            return;
        }
        if (maximum < 0) {
            return;
        }
        if (thumb < 1) {
            return;
        }
        if (increment < 1) {
            return;
        }
        if (pageIncrement < 1) {
            return;
        }
        thumb = Math.min(thumb, maximum - minimum);
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove(adjustment, this.adjustmentHandle);
        adjustment.lower = minimum;
        adjustment.upper = maximum;
        adjustment.step_increment = increment;
        adjustment.page_increment = pageIncrement;
        adjustment.page_size = thumb;
        adjustment.value = Math.min(Math.max(selection, minimum), maximum - thumb);
        OS.memmove(this.adjustmentHandle, adjustment);
        OS.g_signal_handlers_block_matched(this.adjustmentHandle, 16, 0, 0, 0, 0, 49);
        OS.gtk_adjustment_changed(this.adjustmentHandle);
        OS.gtk_adjustment_value_changed(this.adjustmentHandle);
        OS.g_signal_handlers_unblock_matched(this.adjustmentHandle, 16, 0, 0, 0, 0, 49);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        this.parent.setScrollBarVisible(this, visible);
    }
}

