/*
 * Decompiled with CFR 0.152.
 */
package cookxml.core.util;

import cookxml.core.exception.ArrayException;
import cookxml.core.util.ArrayConstructor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ClassUtils {
    private static final Map PRIMITIVE_CLASS_MAP = new HashMap();
    private static final Map PRIMITIVE_ARRAY_CTOR_MAP = new HashMap();
    public static final String THIS_VAR = "this";
    public static final String NULL_VAR = "null";

    public static Class getEquivalentClass(Class srcClass) {
        Class newClass = (Class)PRIMITIVE_CLASS_MAP.get(srcClass.getName());
        if (newClass == null) {
            return srcClass;
        }
        return newClass;
    }

    public static Class getEquivalentClass(String srcClassName) {
        return (Class)PRIMITIVE_CLASS_MAP.get(srcClassName);
    }

    public static Object getArray(String name, int length) throws ArrayException {
        ArrayConstructor ctor = (ArrayConstructor)PRIMITIVE_ARRAY_CTOR_MAP.get(name);
        if (ctor != null) {
            return ctor.create(length);
        }
        try {
            return Array.newInstance(Class.forName(name), length);
        }
        catch (Exception ex) {
            throw new ArrayException(null, (Throwable)ex, name, length);
        }
    }

    public static Object getArray(Class cl, int length) throws ArrayException {
        try {
            return Array.newInstance(cl, length);
        }
        catch (Exception ex) {
            throw new ArrayException(null, (Throwable)ex, "" + cl, length);
        }
    }

    public static void setArray(Object array, int size, Collection collection) {
        Iterator iter = collection.iterator();
        for (int i = 0; i < size; ++i) {
            Array.set(array, i, iter.next());
        }
    }

    public static Object getField(Object obj, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        return ClassUtils.getField(obj, fieldName, false);
    }

    public static Object getField(Object obj, String fieldName, boolean accessible) throws NoSuchFieldException, IllegalAccessException, SecurityException {
        if (fieldName == null || fieldName.length() == 0) {
            return null;
        }
        if (THIS_VAR.equals(fieldName)) {
            return obj;
        }
        Field field = obj.getClass().getDeclaredField(fieldName);
        if (field == null) {
            return null;
        }
        if (accessible) {
            field.setAccessible(true);
        }
        return field.get(obj);
    }

    public static void setField(Object obj, String fieldName, Object value) throws NoSuchFieldException, IllegalAccessException {
        ClassUtils.setField(obj, fieldName, value, false);
    }

    public static void setField(Object obj, String fieldName, Object value, boolean accessible) throws NoSuchFieldException, IllegalAccessException, SecurityException {
        if (fieldName == null || fieldName.length() == 0) {
            return;
        }
        Field field = obj.getClass().getDeclaredField(fieldName);
        if (field == null) {
            return;
        }
        if (accessible) {
            field.setAccessible(true);
        }
        field.set(obj, value);
    }

    public static Object getConstantValue(Class targetClass, String fieldName) {
        try {
            Field field = targetClass.getField(fieldName);
            return field.get(null);
        }
        catch (Exception ex) {
            return null;
        }
    }

    static {
        Map classMap = PRIMITIVE_CLASS_MAP;
        classMap.put("boolean", Boolean.class);
        classMap.put("byte", Byte.class);
        classMap.put("char", Character.class);
        classMap.put("short", Short.class);
        classMap.put("int", Integer.class);
        classMap.put("long", Long.class);
        classMap.put("float", Float.class);
        classMap.put("double", Double.class);
        Map ctorMap = PRIMITIVE_ARRAY_CTOR_MAP;
        ctorMap.put("boolean", new ArrayConstructor(){

            public Object create(int length) {
                return new boolean[length];
            }
        });
        ctorMap.put("byte", new ArrayConstructor(){

            public Object create(int length) {
                return new byte[length];
            }
        });
        ctorMap.put("char", new ArrayConstructor(){

            public Object create(int length) {
                return new char[length];
            }
        });
        ctorMap.put("short", new ArrayConstructor(){

            public Object create(int length) {
                return new short[length];
            }
        });
        ctorMap.put("int", new ArrayConstructor(){

            public Object create(int length) {
                return new int[length];
            }
        });
        ctorMap.put("long", new ArrayConstructor(){

            public Object create(int length) {
                return new long[length];
            }
        });
        ctorMap.put("float", new ArrayConstructor(){

            public Object create(int length) {
                return new float[length];
            }
        });
        ctorMap.put("double", new ArrayConstructor(){

            public Object create(int length) {
                return new double[length];
            }
        });
    }
}

