/*
 * Decompiled with CFR 0.152.
 */
package cookxml.core.setter;

import cookxml.core.DecodeEngine;
import cookxml.core.FunctionHandler;
import cookxml.core.Handler;
import cookxml.core.exception.CookXmlException;
import cookxml.core.exception.NoHandlerException;
import cookxml.core.exception.SetterException;
import cookxml.core.setter.Setter;

public class CallFunctionSetter
implements Setter {
    private final String m_funcName;
    private final Class m_valueClass;
    private final Class m_objectClass;

    public CallFunctionSetter(String funcName, Class parentClass, Class childClass) {
        this.m_funcName = funcName;
        this.m_valueClass = childClass;
        this.m_objectClass = parentClass;
    }

    public void setAttribute(String tag, String attr, Object obj, Object value, DecodeEngine decodeEngine) throws SetterException {
        if (this.m_objectClass != null && !this.m_objectClass.isInstance(obj) || this.m_valueClass != null && !this.m_valueClass.isInstance(value)) {
            throw new SetterException(decodeEngine, null, this, tag, attr, obj, value);
        }
        try {
            CallFunctionSetter.set(tag, obj, value, decodeEngine, this.m_objectClass, this.m_valueClass, this.m_funcName);
        }
        catch (Exception ex) {
            throw new SetterException(decodeEngine, ex, this, tag, attr, obj, value);
        }
    }

    public static void set(String tag, Object obj, Object value, DecodeEngine decodeEngine, Class objectClass, Class valueClass, String funcName) throws CookXmlException {
        Handler handler;
        if (obj == null || objectClass != null && !objectClass.isInstance(obj) || valueClass != null && !valueClass.isInstance(value)) {
            return;
        }
        if (valueClass == null && value != null) {
            valueClass = value.getClass();
        }
        if ((handler = decodeEngine.getHandler(tag, funcName + "/" + valueClass)) == null) {
            handler = FunctionHandler.getHandler(obj, funcName, valueClass);
            if (handler == null) {
                throw new NoHandlerException(decodeEngine, tag, funcName, obj, value);
            }
            decodeEngine.setHandler(tag, funcName + "/" + valueClass, handler);
        }
        handler.invoke(obj, value, decodeEngine);
    }
}

