/*
 * Decompiled with CFR 0.152.
 */
package cookxml.core.adder;

import cookxml.core.DecodeEngine;
import cookxml.core.adder.Adder;
import cookxml.core.exception.AdderException;
import cookxml.core.exception.SetterException;

public class CallSetterAdder
implements Adder {
    private final String m_attr;
    private final Class m_childClass;
    private final Class m_parentClass;

    public CallSetterAdder(String attr, Class parentClass, Class childClass) {
        this.m_attr = attr;
        this.m_childClass = childClass;
        this.m_parentClass = parentClass;
    }

    public boolean add(String parentTag, Object parent, Object child, DecodeEngine decodeEngine) throws AdderException {
        if (parent == null || this.m_childClass == null || !this.m_childClass.isInstance(child) || this.m_parentClass != null && !this.m_parentClass.isInstance(parent)) {
            return false;
        }
        try {
            decodeEngine.callSetter(parentTag, this.m_attr, parent, child);
            return true;
        }
        catch (SetterException ex) {
            throw new AdderException(decodeEngine, ex, this, parentTag, parent, child);
        }
    }
}

