/*
 * Decompiled with CFR 0.152.
 */
package cookxml.core;

import cookxml.core.DecodeEngine;
import cookxml.core.VarLookup;
import cookxml.core.exception.AccessException;
import cookxml.core.exception.VarLookupException;
import cookxml.core.util.ClassUtils;

public class DefaultVarLookup
implements VarLookup {
    public final Object varObject;

    public DefaultVarLookup(Object varObject) {
        this.varObject = varObject;
    }

    public Object getVariable(String name, DecodeEngine decodeEngine) throws VarLookupException {
        if (this.varObject == null || name == null || name.length() == 0) {
            return null;
        }
        try {
            return ClassUtils.getField(this.varObject, name, decodeEngine.getCookXml().isAccessible());
        }
        catch (SecurityException ex) {
            try {
                decodeEngine.handleException(null, new AccessException(decodeEngine, ex, name));
                return null;
            }
            catch (Exception ex2) {
                throw new VarLookupException(decodeEngine, ex, this, name, null, false);
            }
        }
        catch (Exception ex) {
            throw new VarLookupException(decodeEngine, ex, this, name, null, true);
        }
    }

    public void setVariable(String name, Object value, DecodeEngine decodeEngine) throws VarLookupException {
        if (this.varObject == null || name == null || name.length() == 0) {
            return;
        }
        try {
            ClassUtils.setField(this.varObject, name, value, decodeEngine.getCookXml().isAccessible());
        }
        catch (SecurityException ex) {
            try {
                decodeEngine.handleException(null, new AccessException(decodeEngine, ex, name));
            }
            catch (Exception ex2) {
                throw new VarLookupException(decodeEngine, ex, this, name, value, false);
            }
        }
        catch (Exception ex) {
            throw new VarLookupException(decodeEngine, ex, this, name, value, false);
        }
    }
}

