/*
 * Decompiled with CFR 0.152.
 */
package cookxml.common.setter;

import cookxml.common.converter.LocaleConverter;
import cookxml.core.DecodeEngine;
import cookxml.core.exception.SetterException;
import cookxml.core.setter.Setter;
import cookxml.core.stringhook.ResourceBundleStringHook;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class ResourceBundleSetter
implements Setter {
    public static String SEPARATOR = ";";
    private static final Setter s_instance = new ResourceBundleSetter();

    public static Setter getInstance() {
        return s_instance;
    }

    private ResourceBundleSetter() {
    }

    public void setAttribute(String tag, String attr, Object obj, Object value, DecodeEngine decodeEngine) throws SetterException {
        if (value == null || !(value instanceof String)) {
            return;
        }
        ResourceBundle bundle = ResourceBundleSetter.getResourceBundle((String)value);
        if (bundle == null) {
            return;
        }
        decodeEngine.setStringHook(new ResourceBundleStringHook(bundle));
    }

    public static ResourceBundle getResourceBundle(String input) {
        try {
            Locale l;
            if (input == null || input.length() == 0) {
                return null;
            }
            StringTokenizer tokenizer = new StringTokenizer(input, SEPARATOR);
            String baseName = tokenizer.nextToken();
            String locale = null;
            if (tokenizer.hasMoreTokens()) {
                locale = tokenizer.nextToken();
            }
            ResourceBundle bundle = null;
            bundle = locale == null || locale.length() == 0 ? ResourceBundle.getBundle(baseName) : ((l = (Locale)LocaleConverter.getInstance().convert(locale, null)) == null ? ResourceBundle.getBundle(baseName) : ResourceBundle.getBundle(baseName, l));
            return bundle;
        }
        catch (Exception ex) {
            return null;
        }
    }
}

