/*
 * Decompiled with CFR 0.152.
 */
package cookxml.common.creator;

import cookxml.core.DecodeEngine;
import cookxml.core.converter.ObjectConverter;
import cookxml.core.creator.Creator;
import cookxml.core.creator.DefaultCreator;
import cookxml.core.exception.CookXmlException;
import cookxml.core.exception.CreatorException;
import java.lang.reflect.Constructor;
import org.w3c.dom.Element;

public class ObjectCreator
implements Creator {
    private static final Creator s_instance = new ObjectCreator();

    public static Creator getInstance() {
        return s_instance;
    }

    private ObjectCreator() {
    }

    public Object create(String parentTag, Element elm, Object parentObj, String value, DecodeEngine decodeEngine) throws CreatorException {
        try {
            Object obj = null;
            try {
                obj = ObjectConverter.getInstance().convert(value, decodeEngine);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (obj != null) {
                return obj;
            }
            ClassLoader loader = decodeEngine.getCookXml().getClassLoader();
            Class<?> cl = loader.loadClass(value);
            if (cl == null) {
                return null;
            }
            Constructor<?> ctor = cl.getConstructor(DefaultCreator.EMPTY_CLASS_PARAM);
            if (ctor != null) {
                return ctor.newInstance(DefaultCreator.EMPTY_OBJECT_PARAM);
            }
        }
        catch (Exception ex) {
            throw new CreatorException(decodeEngine, ex, this, parentTag, elm, parentObj, value);
        }
        throw new CreatorException(decodeEngine, null, this, parentTag, elm, parentObj, value);
    }

    public Object editFinished(String parentTag, Element elm, Object parentObj, Object obj, DecodeEngine decodeEngine) throws CookXmlException {
        return obj;
    }
}

