/*
 * Decompiled with CFR 0.152.
 */
package cookxml.common.creator;

import cookxml.core.DecodeEngine;
import cookxml.core.creator.Creator;
import cookxml.core.exception.CookXmlException;
import cookxml.core.exception.CreatorException;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.util.StringTokenizer;
import org.w3c.dom.Element;

public class DateFormatCreator
implements Creator {
    public static String TYPE_ATTR = "type";
    public static String DATE_TYPE = "date";
    public static String TIME_TYPE = "time";
    public static String DATETIME_TYPE = "datetime";
    public static String DATE_STYLE_ATTR = "datestyle";
    public static String TIME_STYLE_ATTR = "timestyle";
    private static final Creator s_instance = new DateFormatCreator();
    static /* synthetic */ Class class$java$text$DateFormat;

    public static Creator getInstance() {
        return s_instance;
    }

    private DateFormatCreator() {
    }

    public Object create(String parentTag, Element elm, Object parentObj, String value, DecodeEngine decodeEngine) throws CreatorException {
        try {
            decodeEngine.setDoAdd(false);
            String type = elm.getAttribute("type").toLowerCase();
            if (DATE_TYPE.equals(type)) {
                return DateFormat.getDateInstance(DateFormatCreator.getStyle(elm, DATE_STYLE_ATTR, 2));
            }
            if (TIME_TYPE.equals(type)) {
                return DateFormat.getTimeInstance(DateFormatCreator.getStyle(elm, TIME_STYLE_ATTR, 2));
            }
            return DateFormat.getDateTimeInstance(DateFormatCreator.getStyle(elm, DATE_STYLE_ATTR, 2), DateFormatCreator.getStyle(elm, TIME_STYLE_ATTR, 2));
        }
        catch (Exception ex) {
            throw new CreatorException(decodeEngine, ex, this, parentTag, elm, parentObj, value);
        }
    }

    public Object editFinished(String parentTag, Element elm, Object parentObj, Object obj, DecodeEngine decodeEngine) throws CookXmlException {
        if (obj == null || !(obj instanceof DateFormat)) {
            return obj;
        }
        decodeEngine.addChild(parentTag, elm, parentObj, obj);
        return obj;
    }

    public static int getStyle(Element elm, String styleAttr, int defaultVal) {
        int returnVal = defaultVal;
        try {
            String value = elm.getAttribute(styleAttr);
            if (value == null || value.length() == 0) {
                return returnVal;
            }
            StringTokenizer tokenizer = new StringTokenizer(value, "|");
            do {
                String tok = tokenizer.nextToken().trim();
                Field field = (class$java$text$DateFormat == null ? DateFormatCreator.class$("java.text.DateFormat") : class$java$text$DateFormat).getField(tok);
                returnVal |= field.getInt(null);
            } while (tokenizer.hasMoreElements());
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(styleAttr);
        }
        return returnVal;
    }
}

