/*
 * Decompiled with CFR 0.152.
 */
package cookxml.common.converter;

import cookxml.core.DecodeEngine;
import cookxml.core.converter.Converter;
import cookxml.core.exception.ConverterException;
import java.util.Locale;
import java.util.StringTokenizer;

public class LocaleConverter
implements Converter {
    private static final Converter s_instance = new LocaleConverter();

    public static Converter getInstance() {
        return s_instance;
    }

    private LocaleConverter() {
    }

    public Object convert(String value, DecodeEngine decodeEngine) throws ConverterException {
        try {
            StringTokenizer tokenizer = new StringTokenizer(value, "_");
            String lang = tokenizer.nextToken().trim();
            String country = "";
            String variant = "";
            if (tokenizer.hasMoreTokens()) {
                country = tokenizer.nextToken().trim();
                if (tokenizer.hasMoreTokens()) {
                    variant = tokenizer.nextToken().trim();
                }
            }
            return new Locale(lang, country, variant);
        }
        catch (Exception ex) {
            throw new ConverterException(decodeEngine, (Throwable)ex, this, value);
        }
    }
}

