﻿/*
 *  X-IRC Server
 *   Copyright (C) 2004-2009 Paradoxoft Corporation.
 *   Copyright (C) 2009 Stephanos San Io.
 *  
 *  < GNU GPL v3 Terms >
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;

namespace Server.Provider.Packet
{
    class Processor
    {
        public static bool Process(Connexion TargetConnexion, Queue<byte> PacketQueue)
        {
            try
            {
                // Inside switch use only
                Channel TargetChannel;
                string UserListParameter;
                // Overall process
                byte[] Packet = PacketQueue.ToArray();
                string PacketString = ((Encoding)Program.XDatabase.Get("Provider_DefaultEncoding")).GetString(Packet, 0, Packet.Length - 1); // remove CR/LF
                Console.WriteLine("{0:S}", PacketString);
                // Command Selection
                string[] SplitBySpace, SplitByComma;
                if ((SplitBySpace = Core.Packet.FSplit(PacketString)) == null)
                    return false;
                SplitByComma = PacketString.Substring(PacketString.IndexOf(' ') + 1).Split(',');
                string Command = SplitBySpace[0].ToUpper();
                switch (Command)
                {
                    case "QUIT":
                        // Quit
                        // Not mode-specific
                        // QUIT [<Quit message>]
                        return false;
                    case "NICK":
                        // Nickname Change Command
                        // Mode 0 or Mode 1+ Operation
                        // NICK <nickname>
                        if ((new Regex("[^a-zA-Z0-9]")).IsMatch(SplitBySpace[1]) == true) // Invalid nickname
                            return false;
                        if (TargetConnexion.Mode == 0) // Mode 0
                        {
                            if (Program.XConnexionManager[SplitBySpace[1]] != null) // Nickname used
                            {
                                if (Sender.Message(TargetConnexion, "NOTICE", ":" + (string)Program.XDatabase.Get("Message_0001")) == false)
                                    return false;
                                return false;
                            }
                            else
                                TargetConnexion.Nickname = SplitBySpace[1];
                        }
                        else if (TargetConnexion.Mode >= 1)
                        {
                            if (Program.XConnexionManager[SplitBySpace[1]] != null) // Nickname used
                            {
                                if (Sender.Message(TargetConnexion, Core.Packet.ERR_NICKNAMEINUSE, ":" + (string)Program.XDatabase.Get("Message_0001")) == false)
                                    return false;
                            }
                            else
                            {
                                if (Sender.Message(TargetConnexion, SplitBySpace[0], SplitBySpace[1], true) == false)
                                    return false;
                                TargetConnexion.Nickname = SplitBySpace[1];
                            }
                        }
                        break;
                    case "USER":
                        // Authentication Command
                        // Mode 0 Operation
                        // USER <username> <hostname> <servername> <realname>
                        if (TargetConnexion.Mode != 0)
                            return false;
                        // Username
                        TargetConnexion.Username = SplitBySpace[1];
                        // Nickname
                        TargetConnexion.RealName = SplitBySpace[4];
                        TargetConnexion.Mode = 1;
                        // Welcome Message
                        if (Sender.Message(TargetConnexion, 1, string.Format("{0:S} :{1:S}", TargetConnexion.Nickname, string.Format((string)Program.XDatabase.Get("Message_0101"), (string)Program.XDatabase.Get("Function_ServerName")))) == false)
                            return false;
                        // Server Information
                        if (Sender.Message(TargetConnexion, 5, string.Format("{0:S} MODES=6 MAXCHANNELS={1:D} CHANTYPES=#& PREFIX=(ov)@+ STATUSMSG=@+ CHANMODES=b,k,l,imnpstrDd NETWORK={2:S}", TargetConnexion.Nickname, (string)Program.XDatabase.Get("Function_MaximumJoinableChannel"), (string)Program.XDatabase.Get("Function_ServerShortName"))) == false)
                            return false;
                        // Motd Message
                        if (Sender.Message(TargetConnexion, Core.Packet.RPL_MOTDSTART, string.Format("{0:S} :{1:S}", TargetConnexion.Nickname, string.Format(((string[])Program.XDatabase.Get("Message_0102"))[0], (string)Program.XDatabase.Get("Function_ServerName"), TargetConnexion.Nickname, Program.XChannelManager.ChannelCount, Program.XConnexionManager.ConnexionsCount))) == false)
                            return false;
                        for (int i = 1; i < ((string[])Program.XDatabase.Get("Message_0102")).Length - 1; i++)
                        {
                            if (Sender.Message(TargetConnexion, Core.Packet.RPL_MOTD, string.Format("{0:S} :{1:S}", TargetConnexion.Nickname, string.Format(((string[])Program.XDatabase.Get("Message_0102"))[i], (string)Program.XDatabase.Get("Function_ServerName"), TargetConnexion.Nickname, Program.XChannelManager.ChannelCount, Program.XConnexionManager.ConnexionsCount))) == false)
                                return false;
                        }
                        if (Sender.Message(TargetConnexion, Core.Packet.RPL_ENDOFMOTD, string.Format("{0:S} :{1:S}", TargetConnexion.Nickname, string.Format(((string[])Program.XDatabase.Get("Message_0102"))[((string[])Program.XDatabase.Get("Message_0102")).Length - 1], (string)Program.XDatabase.Get("Function_ServerName"), TargetConnexion.Nickname, Program.XChannelManager.ChannelCount, Program.XConnexionManager.ConnexionsCount))) == false)
                            return false;
                        break;
                    case "MOTD":
                        // Message of The Day Command
                        // Mode 1+ Operation
                        // MOTD
                        if (TargetConnexion.Mode < 1)
                            return false;
                        if (Sender.Message(TargetConnexion, Core.Packet.RPL_MOTDSTART, string.Format("{0:S} :{1:S}", TargetConnexion.Nickname, string.Format(((string[])Program.XDatabase.Get("Message_0102"))[0], (string)Program.XDatabase.Get("Function_ServerName"), TargetConnexion.Nickname, Program.XChannelManager.ChannelCount, Program.XConnexionManager.ConnexionsCount))) == false)
                            return false;
                        for (int i = 1; i < ((string[])Program.XDatabase.Get("Message_0102")).Length - 1; i++)
                        {
                            if (Sender.Message(TargetConnexion, Core.Packet.RPL_MOTD, string.Format("{0:S} :{1:S}", TargetConnexion.Nickname, string.Format(((string[])Program.XDatabase.Get("Message_0102"))[i], (string)Program.XDatabase.Get("Function_ServerName"), TargetConnexion.Nickname, Program.XChannelManager.ChannelCount, Program.XConnexionManager.ConnexionsCount))) == false)
                                return false;
                        }
                        if (Sender.Message(TargetConnexion, Core.Packet.RPL_ENDOFMOTD, string.Format("{0:S} :{1:S}", TargetConnexion.Nickname, string.Format(((string[])Program.XDatabase.Get("Message_0102"))[((string[])Program.XDatabase.Get("Message_0102")).Length - 1], (string)Program.XDatabase.Get("Function_ServerName"), TargetConnexion.Nickname, Program.XChannelManager.ChannelCount, Program.XConnexionManager.ConnexionsCount))) == false)
                            return false;
                        break;
                    case "PING":
                        // Ping Command
                        // Mode 1+ Operation
                        // PING <server1>
                        if (TargetConnexion.Mode < 1)
                            return false;
                        if (Sender.Message(TargetConnexion, "PONG", string.Format("{0:S} :{1:S}", (string)Program.XDatabase.Get("Function_ServerHost"), SplitBySpace[1])) == false)
                            return false;
                        break;
                    case "LIST":
                        // Channel List Command
                        // Mode 1+ Operation
                        // LIST
                        if (TargetConnexion.Mode < 1)
                            return false;
                        // Start
                        if (Sender.Message(TargetConnexion, Core.Packet.RPL_LISTSTART, string.Format("{0:S} Channel :Users  Name", TargetConnexion.Nickname)) == false)
                            return false;
                        // List
                        for (int i = 0; i < Program.XChannelManager.ChannelCount; i++)
                        {
                            if (Sender.Message(TargetConnexion, Core.Packet.RPL_LIST, string.Format("{0:S} {1:S} {2:D} : {3:S}", TargetConnexion.Nickname, Program.XChannelManager[i].Name, (Program.XChannelManager[i].ConnexionList.Count == 0) ? 1 : Program.XChannelManager[i].ConnexionList.Count, Program.XChannelManager[i].Description)) == false)
                                return false;
                        }
                        // End
                        if (Sender.Message(TargetConnexion, Core.Packet.RPL_LISTEND, string.Format("{0:S} :End of LIST", TargetConnexion.Nickname)) == false)
                            return false;
                        break;
                    case "TOPIC":
                        // Channel Topic Command
                        // Mode 1+ Operation, Mode 10+ Operation if topic is specified
                        // TOPIC <channel> [<topic>]
                        if (TargetConnexion.Mode < 1)
                            return false;
                        TargetChannel = Program.XChannelManager[SplitBySpace[1]];
                        if (TargetChannel == null) // No such channel
                        {
                            if (Sender.Message(TargetConnexion, Core.Packet.ERR_NOSUCHCHANNEL, string.Format("{0:S} {1:S} :{2:S}", TargetConnexion.Nickname, SplitBySpace[1], (string)Program.XDatabase.Get("Message_0002"))) == false)
                                return false;
                        }
                        else
                        {
                            // NOTE: need not be a part of the channel in order to get the channel topic information.
                            /*if (TargetConnexion.JointChannelList.Contains(TargetChannel) == false) // Not on the channel
                            {
                                if (Sender.Message(TargetConnexion, Core.Packet.ERR_NOTONCHANNEL, string.Format("{0:S} {1:S} :{2:S}", TargetConnexion.Nickname, SplitBySpace[1], Core.Configuration.Message.M0003)) == false)
                                    return false;
                            }
                            else
                            {*/
                            // NOTE: TOPIC CHANGE NOT SUPPORTED YET.
                            if (SplitBySpace.Length == 3) // Topic is specified
                            {
                                if (TargetConnexion.Mode < 10)
                                    return false;
                                return false;
                            }
                            else // Topic view
                            {
                                if (TargetConnexion.Mode < 1)
                                    return false;
                                if (Sender.Message(TargetConnexion, Core.Packet.RPL_TOPIC, string.Format("{0:S} {1:S} :{2:S}", TargetConnexion.Nickname, TargetChannel.Name, TargetChannel.Description)) == false)
                                    return false;
                            }
                            //}
                        }
                        break;
                    case "NAMES":
                        // Channel Nickname List Command
                        // Mode 1+ Operation
                        // NAMES <channel>
                        if (TargetConnexion.Mode < 1)
                            return false;
                        TargetChannel = Program.XChannelManager[SplitBySpace[1]];
                        if (TargetChannel == null) // No such channel
                        {
                            if (Sender.Message(TargetConnexion, Core.Packet.ERR_NOSUCHCHANNEL, string.Format("{0:S} {1:S} :No such channel", TargetConnexion.Nickname, SplitBySpace[1])) == false)
                                return false;
                        }
                        else
                        {
                            UserListParameter = "";
                            for (int j = 0; j < TargetChannel.ConnexionList.Count; j++)
                                UserListParameter += TargetChannel.ConnexionList.Values[j].Nickname + " ";
                            if (UserListParameter.Length != 0)
                                UserListParameter.Remove(UserListParameter.Length - 1);
                            if (Sender.Message(TargetConnexion, Core.Packet.RPL_NAMREPLY, string.Format("{0:S} = {1:S} :{2:S}", TargetConnexion.Nickname, TargetChannel.Name, UserListParameter)) == false)
                                return false;
                            if (Sender.Message(TargetConnexion, Core.Packet.RPL_ENDOFNAMES, string.Format("{0:S} {1:S} :End of NAMES list", TargetConnexion.Nickname, TargetChannel.Name)) == false)
                                return false;
                        }
                        break;
                    case "WHO":
                        // Channel User Specific Information List Command
                        // Mode 1+ Operation
                        // WHO <channel>
                        if (TargetConnexion.Mode < 1)
                            return false;
                        TargetChannel = Program.XChannelManager[SplitBySpace[1]];
                        if (TargetChannel == null) // No such channel
                        {
                            if (Sender.Message(TargetConnexion, Core.Packet.ERR_NOSUCHCHANNEL, string.Format("{0:S} {1:S} :No such channel", TargetConnexion.Nickname, SplitBySpace[1])) == false)
                                return false;
                        }
                        else
                        {
                            for (int j = 0; j < TargetChannel.ConnexionList.Count; j++)
                            {
                                if (Sender.Message(TargetConnexion, Core.Packet.RPL_WHOREPLY, string.Format("{0:S} {1:S} {2:S} {3:S} {4:S} {5:S} {6:S} :0 {7:S}", TargetConnexion.Nickname, TargetChannel.Name, TargetChannel.ConnexionList.Values[j].Username, (string)Program.XDatabase.Get("Function_ServerHost"), (string)Program.XDatabase.Get("Function_ServerHost"), TargetChannel.ConnexionList.Values[j].Nickname, "H", TargetChannel.ConnexionList.Values[j].RealName)) == false)
                                    return false;
                            }
                            // End
                            if (Sender.Message(TargetConnexion, Core.Packet.RPL_ENDOFWHO, string.Format("{0:S} {1:S} :End of WHO list", TargetConnexion.Nickname, TargetChannel.Name)) == false)
                                return false;
                        }
                        break;
                    case "MODE":
                        // Channel Mode Command
                        // Mode 1+ Operation
                        // WHO <channel>
                        if (TargetConnexion.Mode < 1)
                            return false;
                        TargetChannel = Program.XChannelManager[SplitBySpace[1]];
                        if (TargetChannel == null) // No such channel
                        {
                            if (Sender.Message(TargetConnexion, Core.Packet.ERR_NOSUCHCHANNEL, string.Format("{0:S} {1:S} :No such channel", TargetConnexion.Nickname, SplitBySpace[1])) == false)
                                return false;
                        }
                        else
                        {
                            if (Sender.Message(TargetConnexion, Core.Packet.RPL_CHANNELMODEIS, string.Format("{0:S} {1:S} +tn", TargetConnexion.Nickname, TargetChannel.Name)) == false)
                                return false;
                        }
                        break;
                    case "JOIN":
                        // Channel Join Command
                        // Mode 1+ Operation
                        // JOIN <channel>
                        if (TargetConnexion.Mode < 1)
                            return false;
                        for (int i = 0; i < SplitByComma.Length; i++)
                        {
                            string[] TSplitBySpace;
                            if ((TSplitBySpace = Core.Packet.FSplit(SplitByComma[i])) == null)
                                return false;
                            TargetChannel = Program.XChannelManager[TSplitBySpace[0]];
                            if (TargetChannel == null) // No such channel
                            {
                                if (Sender.Message(TargetConnexion, Core.Packet.ERR_NOSUCHCHANNEL, string.Format("{0:S} {1:S} :No such channel", TargetConnexion.Nickname, TSplitBySpace[0])) == false)
                                    return false;
                            }
                            else // Join
                            {
                                TargetChannel.ConnexionJoin(TargetConnexion);
                                TargetConnexion.JointChannelList.Add(Program.XChannelManager[TSplitBySpace[0]]);
                                // Join Reply
                                if (Sender.Message(TargetConnexion, "JOIN", string.Format(":{0:S}", TargetChannel.Name), true) == false)
                                    return false;
                                // Channel Information
                                if (Sender.Message(TargetConnexion, Core.Packet.RPL_TOPIC, string.Format("{0:S} {1:S} :{2:S}", TargetConnexion.Nickname, TargetChannel.Name, TargetChannel.Description)) == false)
                                    return false;
                                // Channel User List
                                UserListParameter = "";
                                for (int j = 0; j < TargetChannel.ConnexionList.Count; j++)
                                    UserListParameter += TargetChannel.ConnexionList.Values[j].Nickname + " ";
                                UserListParameter.Remove(UserListParameter.Length - 1);
                                if (Sender.Message(TargetConnexion, Core.Packet.RPL_NAMREPLY, string.Format("{0:S} = {1:S} :{2:S}", TargetConnexion.Nickname, TargetChannel.Name, UserListParameter)) == false)
                                    return false;
                                if (Sender.Message(TargetConnexion, Core.Packet.RPL_ENDOFNAMES, string.Format("{0:S} {1:S} :End of NAMES list", TargetConnexion.Nickname, TargetChannel.Name)) == false)
                                    return false;
                            }
                        }
                        break;
                    case "SHELP":
                        // (Non-standard Operation)
                        // Server-specific Commands Help Command
                        // Mode 1+ Operation
                        // SHELP
                        if (TargetConnexion.Mode < 1)
                            return false;
                        for (int i = 0; i < ((string[])Program.XDatabase.Get("Message_1002")).Length; i++)
                        {
                            if (Sender.P_Notice(TargetConnexion, ((string[])Program.XDatabase.Get("Message_1002"))[i]) == false)
                                return false;
                        }
                        break;
                    case "OPERATOR":
                        // (Non-standard Operation)
                        // Become an operator
                        // Mode 1+ Operation
                        // OPERATOR [username] [password]

                        break;
                    default:
                        if (Sender.P_Notice(TargetConnexion, string.Format((string)Program.XDatabase.Get("Message_1001"), PacketString)) == false)
                            return false;
                        break;
                }
                PacketQueue.Clear();
                return true;
            }
            catch
            {
                return false;
            }
        }
    }

    class Sender
    {
        public static bool Message(Connexion TargetConnexion, int Command, string Parameters)
        {
            return Message(TargetConnexion, string.Format("{0:D3}", Command), Parameters, false);
        }

        public static bool Message(Connexion TargetConnexion, string Command, string Parameters)
        {
            return Message(TargetConnexion, Command, Parameters, false);
        }

        public static bool Message(Connexion TargetConnexion, string Command, string Parameters, bool InterServer)
        {
            try
            {
                byte[] PacketToSend;
                if (InterServer == true)
                    //PacketToSend = Core.Configuration.Server_DefaultEncoding.GetBytes(string.Format(":{0:S} {1:S} {2:S}\r\n", TargetConnexion.Nickname, Command, Parameters));
                    PacketToSend = ((Encoding)Program.XDatabase.Get("Provider_DefaultEncoding")).GetBytes(string.Format(":{0:S}!{1:S}@{2:S} {3:S} {4:S}\r\n", TargetConnexion.Nickname, TargetConnexion.Username, (string)Program.XDatabase.Get("Function_ServerHost"), Command, Parameters));
                else
                    PacketToSend = ((Encoding)Program.XDatabase.Get("Provider_DefaultEncoding")).GetBytes(string.Format(":{0:S} {1:S} {2:S}\r\n", (string)Program.XDatabase.Get("Function_ServerHost"), Command, Parameters));
                TargetConnexion.Send(PacketToSend);
                return true;
            }
            catch
            {
                return false;
            }
        }

        public static bool P_Notice(Connexion TargetConnexion, string Message)
        {
             return Sender.Message(TargetConnexion, "NOTICE", string.Format("{0:S} :{1:S}", TargetConnexion.Nickname, Message));
        }
    }
}