﻿/*
 *  X-IRC Server, Crap DB Manager
 *   Copyright (C) 2004-2009 Paradoxoft Corporation.
 *   Copyright (C) 2009 Stephanos San Io.
 *  
 *  < GNU GPL v3 Terms >
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

using System;
using System.Text;
using System.Net;
using System.Threading;
using System.Windows.Forms;
using System.ComponentModel;

namespace CrapDBManager
{
    class DatabaseFile
    {
        public Encoding Provider_DefaultEncoding = Encoding.UTF8;
        public IPEndPoint[] Provider_EndPoints = { new IPEndPoint(IPAddress.Parse("127.0.0.1"), 6667), new IPEndPoint(IPAddress.Parse("192.168.99.108"), 6667) };
        public int Provider_Backlogs = 32;
        public int Provider_MaximumConnexions = 1024;
        public int Provider_ReceiveBufferSize = 8192;
        public int Provider_MaximumReceivedPacketsPerSecond = 20;
        public int Provider_MaximumReceivedBytesPerSecond = 3000;

        public string Function_ServerHost = "localhost";
        public string Function_ServerName = "LocalHost Server";
        public string Function_ServerShortName = "LocalHost"; // Short name must not include any spaces
        public int Function_MaximumJoinableChannel = 20;
    }

    static class Program
    {
        public static DatabaseFile XDatabaseFile = new DatabaseFile();

        [MTAThread]
        static void Main()
        {
            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);
            Console.BackgroundColor = ConsoleColor.White;
            Console.ForegroundColor = ConsoleColor.DarkGreen;
            Console.Clear();
            Console.WriteLine("X-IRC Server, Crap DB Manager");
            Console.WriteLine(" Copyright (C) 2004-2009 Paradoxoft Corporation.");
            Console.WriteLine(" Copyright (C) 2009 Stephanos San Io.");
            Console.WriteLine();
            Console.WriteLine("Hello! This is the Crap DB Manager for ya!");
            goto BORED;
            Thread.Sleep(1000);
            Console.WriteLine("I know what you are thinking right now.");
            Thread.Sleep(2000);
            Console.WriteLine("Ya ... this is a crap. ... yes, it is, for sure ...");
            Thread.Sleep(4000);
            Console.WriteLine("But, not actually .. the DB structure is kinda crappy but the manager ain't, at least it is better than a crap ..");
            Thread.Sleep(5000);
            Console.WriteLine("Just a sec ... ");
            Thread.Sleep(3000);
            Console.WriteLine("There you go! LOL");
            BORED:
            Application.Run(new MainForm());
        }
    }
}
