CREATE TABLE phpbb_weblog_groups(group_id SMALLINT (5) UNSIGNED DEFAULT '0' NOT NULL, PRIMARY KEY(group_id));

CREATE TABLE phpbb_weblog_config(config_name VARCHAR (255) NOT NULL, config_value VARCHAR (255) NOT NULL, PRIMARY KEY(config_name));
INSERT INTO phpbb_weblog_config(config_name, config_value) VALUES ('config_id', '1');
INSERT INTO phpbb_weblog_config(config_name, config_value) VALUES ('display_stats', '1');
INSERT INTO phpbb_weblog_config(config_name, config_value) VALUES ('default_access', '0');
INSERT INTO phpbb_weblog_config(config_name, config_value) VALUES ('default_entries', '5');
INSERT INTO phpbb_weblog_config(config_name, config_value) VALUES ('default_name', '%s-Blog');
INSERT INTO phpbb_weblog_config(config_name, config_value) VALUES ('default_desc', 'Welcome to my new blog!');
INSERT INTO phpbb_weblog_config(config_name, config_value) VALUES ('default_comment', 'Comments: %s');
INSERT INTO phpbb_weblog_config(config_name, config_value) VALUES ('default_post_comment', '(Post a comment)');
INSERT INTO phpbb_weblog_config(config_name, config_value) VALUES ('weblogs_per_page', '10');
INSERT INTO phpbb_weblog_config(config_name, config_value) VALUES ('weblog_sort', '1');
INSERT INTO phpbb_weblog_config(config_name, config_value) VALUES ('weblog_order', 'desc');
INSERT INTO phpbb_weblog_config(config_name, config_value) VALUES ('weblog_create', '1');
INSERT INTO phpbb_weblog_config(config_name, config_value) VALUES ('allow_advanced', '0');
INSERT INTO phpbb_weblog_config(config_name, config_value) VALUES ('birthday_mod', '0');
INSERT INTO phpbb_weblog_config(config_name, config_value) VALUES ('birthday_zodiac_mod', '0');
INSERT INTO phpbb_weblog_config(config_name, config_value) VALUES ('gender_mod', '0');
INSERT INTO phpbb_weblog_config(config_name, config_value) VALUES ('last_visit_mod', '0');

CREATE TABLE phpbb_weblog_mood(mood_id SMALLINT (5) UNSIGNED NOT NULL AUTO_INCREMENT, image_url VARCHAR (100), mood VARCHAR (75), PRIMARY KEY(mood_id));
INSERT INTO phpbb_weblog_mood(image_url, mood) VALUES ('mood_none.gif', '(none)');
INSERT INTO phpbb_weblog_mood(image_url, mood) VALUES ('mood_angelic.gif', 'Angelic');
INSERT INTO phpbb_weblog_mood(image_url, mood) VALUES ('mood_confused.gif', 'Confused');
INSERT INTO phpbb_weblog_mood(image_url, mood) VALUES ('mood_cool.gif', 'Cool');
INSERT INTO phpbb_weblog_mood(image_url, mood) VALUES ('mood_silly.gif', 'Silly');
INSERT INTO phpbb_weblog_mood(image_url, mood) VALUES ('mood_verysad.gif', 'Very Sad');
INSERT INTO phpbb_weblog_mood(image_url, mood) VALUES ('mood_shocked.gif', 'Shocked');
INSERT INTO phpbb_weblog_mood(image_url, mood) VALUES ('mood_evil.gif', 'Evil');
INSERT INTO phpbb_weblog_mood(image_url, mood) VALUES ('mood_love.gif', 'In Love');
INSERT INTO phpbb_weblog_mood(image_url, mood) VALUES ('mood_amused.gif', 'Amused');
INSERT INTO phpbb_weblog_mood(image_url, mood) VALUES ('mood_angry.gif', 'Angry');
INSERT INTO phpbb_weblog_mood(image_url, mood) VALUES ('mood_neutral.gif', 'Neutral');
INSERT INTO phpbb_weblog_mood(image_url, mood) VALUES ('mood_sick.gif', 'Sick');
INSERT INTO phpbb_weblog_mood(image_url, mood) VALUES ('mood_scared.gif', 'Scared');
INSERT INTO phpbb_weblog_mood(image_url, mood) VALUES ('mood_happy.gif', 'Happy');
INSERT INTO phpbb_weblog_mood(image_url, mood) VALUES ('mood_fedup.gif', 'Fed Up With Life');
INSERT INTO phpbb_weblog_mood(image_url, mood) VALUES ('mood_distorted.gif', 'Distorted');
INSERT INTO phpbb_weblog_mood(image_url, mood) VALUES ('mood_hypnotized.gif', 'Hypnotized');
INSERT INTO phpbb_weblog_mood(image_url, mood) VALUES ('mood_embarrased.gif', 'Embarrased');
INSERT INTO phpbb_weblog_mood(image_url, mood) VALUES ('mood_sleepy.gif', 'Sleepy');

CREATE TABLE phpbb_weblog_currently(currently_id SMALLINT (5) UNSIGNED NOT NULL AUTO_INCREMENT, image_url VARCHAR (100), currently VARCHAR (75), PRIMARY KEY(currently_id));
INSERT INTO phpbb_weblog_currently(currently_id, image_url, currently) VALUES (1, 'currently_none.gif', '(none)');
INSERT INTO phpbb_weblog_currently(currently_id, image_url, currently) VALUES (2, 'currently_eat.gif', 'Eating');
INSERT INTO phpbb_weblog_currently(currently_id, image_url, currently) VALUES (3, 'currently_listen.gif', 'Listening to');
INSERT INTO phpbb_weblog_currently(currently_id, image_url, currently) VALUES (4, 'currently_play.gif', 'Playing');
INSERT INTO phpbb_weblog_currently(currently_id, image_url, currently) VALUES (5, 'currently_read.gif', 'Reading');
INSERT INTO phpbb_weblog_currently(currently_id, image_url, currently) VALUES (6, 'currently_watch.gif', 'Watching');
INSERT INTO phpbb_weblog_currently(currently_id, image_url, currently) VALUES (7, 'currently_work.gif', 'Working');
INSERT INTO phpbb_weblog_currently(currently_id, image_url, currently) VALUES (8, 'currently_custom.gif', '(custom)');

CREATE TABLE phpbb_weblog_styles(style_id SMALLINT(5) UNSIGNED NOT NULL AUTO_INCREMENT, style_name VARCHAR(100) NOT NULL, style_dir VARCHAR(100) NOT NULL, PRIMARY KEY(style_id));

ALTER TABLE phpbb_users ADD user_weblog SMALLINT(5);
ALTER TABLE phpbb_users ADD weblog_start_date INT(11) UNSIGNED;
ALTER TABLE phpbb_users ADD weblog_show_entries SMALLINT(5) UNSIGNED DEFAULT '5';
ALTER TABLE phpbb_users ADD weblog_access SMALLINT(5) DEFAULT '0';
ALTER TABLE phpbb_users ADD weblog_access2 SMALLINT(5) DEFAULT '0';
ALTER TABLE phpbb_users ADD weblog_visible TINYINT(1) DEFAULT '1';
ALTER TABLE phpbb_users ADD weblog_group SMALLINT(5) UNSIGNED DEFAULT '0';
ALTER TABLE phpbb_users ADD weblog_show_profile TINYINT(1) NOT NULL DEFAULT '1';
ALTER TABLE phpbb_users ADD weblog_show_desc TINYINT(1) NOT NULL DEFAULT '1';
ALTER TABLE phpbb_users ADD weblog_contact_info TINYINT(1) NOT NULL DEFAULT '1';
ALTER TABLE phpbb_users ADD weblog_show_info TINYINT(1) NOT NULL DEFAULT '1';
ALTER TABLE phpbb_users ADD weblog_advanced TINYINT(1) NOT NULL DEFAULT '0';
ALTER TABLE phpbb_users ADD weblog_post_comment_name VARCHAR(255) DEFAULT '(Post your comment)';
ALTER TABLE phpbb_users ADD weblog_comment_name VARCHAR(255) DEFAULT 'Comments: %s';
ALTER TABLE phpbb_users ADD weblog_style VARCHAR(30) DEFAULT '';
ALTER TABLE phpbb_users ADD INDEX(user_weblog);

ALTER TABLE phpbb_categories ADD cat_allow_weblogs TINYINT(1) UNSIGNED DEFAULT '0';
ALTER TABLE phpbb_topics ADD topic_mood TINYINT(2) UNSIGNED NOT NULL DEFAULT '0';
ALTER TABLE phpbb_topics ADD topic_auth TINYINT(4) UNSIGNED NOT NULL DEFAULT '0';
ALTER TABLE phpbb_topics ADD topic_currently1 TINYINT(2) UNSIGNED NOT NULL DEFAULT '0';
ALTER TABLE phpbb_topics ADD topic_currently2 VARCHAR(100) NOT NULL DEFAULT '';
ALTER TABLE phpbb_posts ADD post_mood TINYINT(2) UNSIGNED NOT NULL DEFAULT '0';
ALTER TABLE phpbb_posts ADD post_currently1 TINYINT(2) UNSIGNED NOT NULL DEFAULT '0';
ALTER TABLE phpbb_posts ADD post_currently2 VARCHAR(100) NOT NULL DEFAULT '';
ALTER TABLE phpbb_forums ADD forum_views INT(11) UNSIGNED DEFAULT '0';
