<?php
/***************************************************************************
 *                             album_update.php
 *                            -------------------
 *   begin                : Sunday, February 09, 2003
 *   copyright            : (C) 2003 Smartor
 *   email                : smartor_xp@hotmail.com
 *
 *   $Id: album_update.php,v 1.2 2003/03/03 11:29:17 ngoctu Exp $
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

@set_time_limit(3600); // <grin>

define('IN_PHPBB', true);

$phpbb_root_path = './';
include($phpbb_root_path.'extension.inc');
include($phpbb_root_path.'common.'.$phpEx);

$userdata = session_pagestart($user_ip, PAGE_INDEX);
init_userprefs($userdata);

include($phpbb_root_path.'includes/db.'.$phpEx);

define('NEW_ALBUM_VERSION', '.0.51');

?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html;">
<meta http-equiv="Content-Style-Type" content="text/css">
<style type="text/css">
<!--

font,th,td,p,body { font-family: "Courier New", courier; font-size: 11pt }

a:link,a:active,a:visited { color : #006699; }
a:hover		{ text-decoration: underline; color : #DD6900;}

hr	{ height: 0px; border: solid #D1D7DC 0px; border-top-width: 1px;}

.maintitle,h1,h2	{font-weight: bold; font-size: 22px; font-family: "Trebuchet MS",Verdana, Arial, Helvetica, sans-serif; text-decoration: none; line-height : 120%; color : #000000;}

.ok {color:green}

-->
</style>
</head>
<body bgcolor="#FFFFFF" text="#000000" link="#006699" vlink="#5584AA">

<table width="100%" border="0" cellspacing="0" cellpadding="10" align="center">
	<tr>
		<td><table width="100%" border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td align="center" width="100%" valign="middle"><span class="maintitle">Updating Photo Album Addon 2 for phpBB2</span></td>
			</tr>
		</table></td>
	</tr>
</table>

<br clear="all" />

<?php
//
// Get the current version
//
$sql = "SELECT *
		FROM ". $table_prefix ."album_config
		WHERE config_name = 'album_version'";
if( !$result = $db->sql_query($sql) )
{
	die('<b>ERROR:</b> Could not find the existed version of Photo Album here');
}
$row = $db->sql_fetchrow($result);
$current_album_version = $row['config_value'];

$sql = array();

$post_update_note = '';

switch ($current_album_version)
{
	case '.0.0 BETA 1':
	case '.0.0 BETA 2':
		$sql[] = "INSERT INTO ". $table_prefix ."album_config
				VALUES ('hotlink_allowed', 'smartor.is-root.com')";

		$sql[] = "INSERT INTO ". $table_prefix ."album_config
				VALUES ('user_pics_limit', '50')";

		$sql[] = "INSERT INTO ". $table_prefix ."album_config
				VALUES ('mod_pics_limit', '250')";

		// do NOT break here, we must get some more queries since BETA 3

	case '.0.0 BETA 3':
		$sql[] = "ALTER TABLE ". $table_prefix ."album
				ADD pic_username varchar(32)";

		$sql[] = "ALTER TABLE ". $table_prefix ."album
				ADD pic_approval tinyint(3) NOT NULL DEFAULT '1'";

		$sql[] = "ALTER TABLE ". $table_prefix ."album_cat
				ADD cat_approval tinyint(3) NOT NULL DEFAULT '0'";

		$sql[] = "ALTER TABLE ". $table_prefix ."album_comment
				ADD comment_username varchar(32)";

		// do NOT break here, we must get some more queries since BETA 4

	case '.0.0 BETA 4':
		$sql[] = "ALTER TABLE ". $table_prefix ."album_cat
				ADD cat_view_groups varchar(255)";

		$sql[] = "ALTER TABLE ". $table_prefix ."album_cat
				ADD cat_upload_groups varchar(255)";

		$sql[] = "ALTER TABLE ". $table_prefix ."album_cat
				ADD cat_rate_groups varchar(255)";

		$sql[] = "ALTER TABLE ". $table_prefix ."album_cat
				ADD cat_comment_groups varchar(255)";

		$sql[] = "ALTER TABLE ". $table_prefix ."album_cat
				ADD cat_edit_groups varchar(255)";

		$sql[] = "ALTER TABLE ". $table_prefix ."album_cat
				ADD cat_delete_groups varchar(255)";

		$sql[] = "ALTER TABLE ". $table_prefix ."album
				ADD pic_desc text";

		$sql[] = "INSERT INTO ". $table_prefix ."album_config
				VALUES ('desc_length', '512')";

		$sql[] = "INSERT INTO ". $table_prefix ."album_config
				VALUES ('rate_scale', '10')";

		// do NOT break here, we must get some more queries since BETA 5

	case '.0.0 BETA 5':

		$sql[] = "INSERT INTO ". $table_prefix ."album_config
				VALUES ('sort_method', 'pic_time')";

		$sql[] = "INSERT INTO ". $table_prefix ."album_config
				VALUES ('sort_order', 'DESC')";

		$sql[] = "INSERT INTO ". $table_prefix ."album_config
				VALUES ('fullpic_popup', '1')";

		// do NOT break here, we must get some more queries since BETA 6

	case '.0.0 BETA 6':

	case '.0.0 Final':

	case '.0.1':

	case '.0.2':

	case '.0.3':

	case '.0.31':

	case '.0.35':
		
		$post_update_note .= 'Please run <b>album_quote_fix.php</b> too!<br />';

	case '.0.4':

	case '.0.41':

	case '.0.42':

	case '.0.43':

	case '.0.44':
	
	case '.0.45':

	case '.0.46':

	case '.0.47':

	case '.0.48':

	case '.0.49':

	case '.0.5':

		break; // We MUST break here before the default case

	default:
		// it seems the current version is newer
		die('<b>ERROR:</b> Your current version is not specified or NEWER. So you cannot update!');
}
// Finally, update the verions number
$sql[] = "UPDATE ". $table_prefix ."album_config
		SET config_value = '" . NEW_ALBUM_VERSION . "'
		WHERE config_name = 'album_version'";

echo '<b>Your current version:</b>&nbsp; 2' . $current_album_version .'<br />';
echo '<b>Updating to version:</b>&nbsp; 2' . NEW_ALBUM_VERSION .'<br />';
echo '<br /><br />';
flush();

$n = 0;
$errored = FALSE;

while ($sql[$n])
{
	echo 'Running :: ' . $sql[$n] . ' -> ';
	flush();

	if( !$result = $db->sql_query($sql[$n]) )
	{
		$errored = TRUE;
		$error_msg = $db->sql_error();
		echo '<b>FAILED</b>: ' . $error_msg['message'] . "<br /><br />\n";
	}
	else
	{
		echo "<b><span class=\"ok\">COMPLETED</span></b><br /><br />\n\n";
	}

	$n++;
}

if ( $errored )
{
	$message .= '<br />Some queries failed. Please contact me at <a href="http://smartor.is-root.com">http://smartor.is-root.com</a> we may solve your problems...';
}
else
{
	$message .= '<br />Photo Album Tables updated successfully.';
}

echo $post_update_note;
echo "\n<br />\n<b>UPGRADE COMPLETED!</b><br />\n";
echo $message . '<br />';
echo "<br /><b>NOW DELETE THIS FILE</b><br />\n";
echo "</body>";
echo "</html>";

?>