#
# Photo Album Addon v2.x.x for phpBB 2.0.4 - MySQL schema & basic (by Smartor)
#

CREATE TABLE phpbb_album (
	pic_id int(11) UNSIGNED NOT NULL auto_increment,
	pic_filename varchar(255) NOT NULL,
	pic_thumbnail varchar(255),
	pic_title varchar(255) NOT NULL,
	pic_desc text,
	pic_user_id mediumint(8) NOT NULL,
	pic_username varchar(32),
	pic_user_ip char(8) NOT NULL DEFAULT '0',
	pic_time int(11) UNSIGNED NOT NULL,
	pic_cat_id mediumint(8) UNSIGNED NOT NULL DEFAULT '1',
	pic_view_count int(11) UNSIGNED NOT NULL DEFAULT '0',
	pic_lock tinyint(3) NOT NULL DEFAULT '0',
	pic_approval tinyint(3) NOT NULL DEFAULT '1',
	PRIMARY KEY (pic_id),
	KEY pic_cat_id (pic_cat_id),
	KEY pic_user_id (pic_user_id),
	KEY pic_time (pic_time));

CREATE TABLE phpbb_album_rate (
	rate_pic_id int(11) UNSIGNED NOT NULL,
	rate_user_id mediumint(8) NOT NULL,
	rate_user_ip char(8) NOT NULL,
	rate_point tinyint(3) UNSIGNED NOT NULL,
	KEY rate_pic_id (rate_pic_id),
	KEY rate_user_id (rate_user_id),
	KEY rate_user_ip (rate_user_ip),
	KEY rate_point (rate_point));

CREATE TABLE phpbb_album_comment (
	comment_id int(11) UNSIGNED NOT NULL auto_increment,
	comment_pic_id int(11) UNSIGNED NOT NULL,
	comment_user_id mediumint(8) NOT NULL,
	comment_username varchar(32),
	comment_user_ip char(8) NOT NULL,
	comment_time int(11) UNSIGNED NOT NULL,
	comment_text TEXT,
	comment_edit_time int(11) UNSIGNED,
	comment_edit_count smallint(5) UNSIGNED NOT NULL DEFAULT '0',
	comment_edit_user_id mediumint(8),
	PRIMARY KEY(comment_id),
	KEY comment_pic_id (comment_pic_id),
	KEY comment_user_id (comment_user_id),
	KEY comment_user_ip (comment_user_ip),
	KEY comment_time (comment_time));

CREATE TABLE phpbb_album_cat (
	cat_id mediumint(8) UNSIGNED NOT NULL auto_increment,
	cat_title varchar(255) NOT NULL,
	cat_desc text,
	cat_order mediumint(8) NOT NULL,
	cat_view_level tinyint(3) NOT NULL DEFAULT '-1',
	cat_upload_level tinyint(3) NOT NULL DEFAULT '0',
	cat_rate_level tinyint(3) NOT NULL DEFAULT '0',
	cat_comment_level tinyint(3) NOT NULL DEFAULT '0',
	cat_edit_level tinyint(3) NOT NULL DEFAULT '0',
	cat_delete_level tinyint(3) NOT NULL DEFAULT '2',
	cat_view_groups varchar(255),
	cat_upload_groups varchar(255),
	cat_rate_groups varchar(255),
	cat_comment_groups varchar(255),
	cat_edit_groups varchar(255),
	cat_delete_groups varchar(255),
	cat_moderator_groups varchar(255),
	cat_approval tinyint(3) NOT NULL DEFAULT '0',
	PRIMARY KEY (cat_id),
	KEY cat_order (cat_order));

CREATE TABLE phpbb_album_config (
	config_name varchar(255) NOT NULL,
	config_value varchar(255) NOT NULL,
	PRIMARY KEY (config_name));

INSERT INTO phpbb_album_config VALUES ('max_pics', '1024');
INSERT INTO phpbb_album_config VALUES ('user_pics_limit', '50');
INSERT INTO phpbb_album_config VALUES ('mod_pics_limit', '250');
INSERT INTO phpbb_album_config VALUES ('max_file_size', '128000');
INSERT INTO phpbb_album_config VALUES ('max_width', '800');
INSERT INTO phpbb_album_config VALUES ('max_height', '600');
INSERT INTO phpbb_album_config VALUES ('rows_per_page', '3');
INSERT INTO phpbb_album_config VALUES ('cols_per_page', '4');
INSERT INTO phpbb_album_config VALUES ('fullpic_popup', '1');
INSERT INTO phpbb_album_config VALUES ('thumbnail_quality', '50');
INSERT INTO phpbb_album_config VALUES ('thumbnail_size', '125');
INSERT INTO phpbb_album_config VALUES ('thumbnail_cache', '1');
INSERT INTO phpbb_album_config VALUES ('sort_method', 'pic_time');
INSERT INTO phpbb_album_config VALUES ('sort_order', 'DESC');
INSERT INTO phpbb_album_config VALUES ('jpg_allowed', '1');
INSERT INTO phpbb_album_config VALUES ('png_allowed', '1');
INSERT INTO phpbb_album_config VALUES ('gif_allowed', '0');
INSERT INTO phpbb_album_config VALUES ('desc_length', '512');
INSERT INTO phpbb_album_config VALUES ('hotlink_prevent', '0');
INSERT INTO phpbb_album_config VALUES ('hotlink_allowed', 'smartor.is-root.com');
INSERT INTO phpbb_album_config VALUES ('personal_gallery', '0');
INSERT INTO phpbb_album_config VALUES ('personal_gallery_private', '0');
INSERT INTO phpbb_album_config VALUES ('personal_gallery_limit', '10');
INSERT INTO phpbb_album_config VALUES ('personal_gallery_view', '-1');
INSERT INTO phpbb_album_config VALUES ('rate', '1');
INSERT INTO phpbb_album_config VALUES ('rate_scale', '10');
INSERT INTO phpbb_album_config VALUES ('comment', '1');
INSERT INTO phpbb_album_config VALUES ('gd_version', '1');
INSERT INTO phpbb_album_config VALUES ('album_version', '.0.51');