<?php // $Id: submit.php,v 20.8 2004/01/07 22:10:22 EllselAn Exp $
/************************************************************************/
/* KalenderMx v1.3                                                      */
/* ===================                                                  */
/*  Calendar Module for vkpMx 2.x & phpNuke 5.5-7.0                     */
/*  Copyright (c) 2004 by A.Ellsel (kalender@pragmamx.org)              */
/*  http://www.pragmamx.org & http://ww.shiba-design.de                 */
/* -------------------------------------------------------------------- */
/* KalenderMx is based on EventCalendar 2.0                             */
/*  Copyright (c) 2001 Originally by Rob Sutton                         */
/*  http://smart.xnettech.net (Nuke Site)                               */
/*  Development continued by Aleks A.-Lessmann                          */
/* Included some ideas and changes by:                                  */
/*  flobee, bulli-frank, kicks, kochloeffel, FrankySz, Jubilee          */
/* -------------------------------------------------------------------- */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 or a newer version.   */
/************************************************************************/
if (eregi(basename(__file__), $_SERVER["PHP_SELF"])) die ("classement: You can't access this file directly...");

if (!defined("CAL_MODULE_NAME")) define("CAL_MODULE_NAME",basename(dirname(__FILE__)));
if (!defined("CAL_MODULE_PATH")) define("CAL_MODULE_PATH","modules/".CAL_MODULE_NAME."/");

if (!isset($calconf))             include(CAL_MODULE_PATH."config/config.php");
if (!defined("CAL_TABLE_EVENTS")) include_once(CAL_MODULE_PATH."includes/functions.php");
get_lang(CAL_MODULE_NAME);

#########################################################################################
function calSubmitStart($gvs) {
	global $dbi, $calconf;
	$user = (isset($_COOKIE['user'])) ? $_COOKIE['user'] : "";
	if (is_user($user)) {
		$cookie = cookiedecode($user);
		$event["informant"] = $cookie[1];
		}
	else {
		$event["informant"] = $GLOBALS["anonymous"];
		}
	if (calIsPostAllowed()){
		$sd = (isset($gvs["sd"])) ? $gvs["sd"] : Date("Y-m-d");
		$event["aid"]       = calIsAdmin();
		$event["topic"]     = 0;
		$event["categorie"] = 0;
		$event["title"]     = "";
		$event["hometext"]  = "";
		$event["startDate"] = $sd;
		$event["startTime"] = $calconf['TimeArray'][0]; #"09:00:00";
		$event["endDate"]   = $sd;
		$event["endTime"]   = $calconf['TimeArray'][2]; #"10:00:00";
		#$event["posteddate"]= 0;
		$event["op"]        = ($event["aid"]) ? "CalendarNewEvent" : "newEvent";
		$GLOBALS["pagetitle"] = _CALSUBMITNAME;
		if (empty($GLOBALS['header'])) include_once("header.php");
		if (calIsAdmin()) {
			calAdminMenu(_CALSUBMITNAME);
			}
		else {
			title(_CALSUBMITNAME);
			}
		calSubmitForm($event);
		include("footer.php");
		}
	else {
		Header("Location: ".CAL_MOD_USERLOGIN);
		}
	}

#########################################################################################
function calNewEventPreview($event) { # post
	global $dbi, $calconf, $user;
	$event = calStripSlashes($event);
	$GLOBALS["pagetitle"]=_CALNEWSUBPREVIEW;
	if (empty($GLOBALS['header'])) include_once("header.php");
	if (calIsAdmin()) {
		calAdminMenu(_CALNEWSUBPREVIEW);
		}
	else {
		title(_CALNEWSUBPREVIEW);
		}
	OpenTable();
	echo "<center><i>"._CALSTORYLOOK."</i></center>";
	CloseTable();
	echo "<br>";
  calEventView($event);
	calSubmitForm($event);
	include("footer.php");
	}

#########################################################################################
function calNewEventSubmit($event) { # post
	global $dbi, $calconf, $user;
	$event = calPrepareEventForSql($event);
	$qry = calGetSqlQuery($event, "insert");
	$result = sql_query($qry, $dbi);
	if ($result) {
		if ($event["addasarticle"]){
			calAddArticle($event);
			}
		Header("Location: ".CAL_MODULE_LINK."&file=submit&op=calSubmitThanks&sd=".$event["startDate"]."");
		}
	else {
		calErrAdminMsg(_CALERRSQLERROR);
		}
	}

#########################################################################################
function calSubmitThanks($gvs) {
	global $dbi, $calconf;
	$sd = (isset($gvs["sd"])) ? $gvs["sd"] : Date("Y-m-d");
	$date = explode("-", $sd); # Y-m-d
	$qry="select count(eid) from ".CAL_TABLE_EVENTS." where activ=0";
	$result = sql_query($qry, $dbi);
	list($waiting) = sql_fetch_row($result, $dbi);
	$user = (isset($_COOKIE['user'])) ? $_COOKIE['user'] : "";
	if (is_user($user)) {
		$autoactive = (empty($calconf['userautoactive'])) ? 0 : 1;
	  }
	else {
		$autoactive = (empty($calconf['anonautoactive'])) ? 0 : 1;
		}
	$msg = (calIsAdmin() || $autoactive) ? _CALSUBTEXTADMIN : _CALSUBTEXT;
	$GLOBALS["pagetitle"]=_CALNAME;
	if (empty($GLOBALS['header'])) include_once("header.php");
	if (calIsAdmin()) {
		calAdminMenu(_CALNAME);
		}
	else {
		title(_CALNAME);
		}
	OpenTable();
	echo "<center>"._CALSUBSENT."<br><br><font class=\"title\"><b>"._CALTHANKSSUB."</b></font><br>";
	echo "<br>$msg<br><br>"._CALWEHAVESUB." $waiting "._CALWAITING."</center>";
	CloseTable();
	echo "<br>";
	calBuildModusselectors("", $date[2], $date[1], $date[0]); # 4/23/2002
	include("footer.php");
	}

#########################################################################################

$op = (isset($_REQUEST["op"])) ? $_REQUEST["op"] : "";
switch($op) {
	case "calNewEventPreview":
		calNewEventPreview($_POST);
		break;
	case "calNewEventSubmit":
		calNewEventSubmit($_POST);
		break;
	case "calSubmitThanks":
		calSubmitThanks($_GET);
		break;
	default:
		calSubmitStart($_GET);
		break;
	}
?>