#!/usr/bin/env python
from wxPython.wx import *
from wxk_winresult import wxKWinResult
from wxk_winsupp import wxKWinSupp
from wxk_edit import wxKEditor
#-------------------------------------------------------------------------------
class wxKPanelMain(wxPanel):
    #---------------------------------------------------------------------------
    ID_WINDOW_LEFT   = 5101
    ID_WINDOW_BOTTOM = 5102
    #---------------------------------------------------------------------------
    def __init__(self, parent, id, pos = wxDefaultPosition, size = wxDefaultSize, style = wxTAB_TRAVERSAL,name = "panel"):
        wxPanel.__init__(self, parent, id, pos, size, style, name)
        self.InitWindow()
        EVT_SIZE(self, self.OnSize)
        EVT_ERASE_BACKGROUND(self.m_SplitEdit, self.EmptyHandler)
        EVT_SASH_DRAGGED_RANGE(self, self.ID_WINDOW_LEFT, self.ID_WINDOW_BOTTOM, self.OnSashDrag)
    #---------------------------------------------------------------------------
    def InitWindow(self):
        self.m_SplitEdit=wxSplitterWindow(self, -1, wxPoint(0,0), wxSize(300,180), style=wxNO_3D|wxSP_3DSASH|wxSIMPLE_BORDER )

        self.m_NoteBookEdit=wxNotebook(self.m_SplitEdit, -1, wxDefaultPosition, wxSize(80,180), wxNO_3D )
        self.m_Editor=wxKEditor(self.m_NoteBookEdit, -1, style=wxSIMPLE_BORDER)
        self.m_NoteBookEdit.AddPage(self.m_Editor, "untitled")

        self.m_NoteBookEdit2=wxNotebook(self.m_SplitEdit, -1, wxDefaultPosition, wxSize(80,180), wxNO_3D )
        self.m_Editor2=wxKEditor(self.m_NoteBookEdit2, -1, style=wxSIMPLE_BORDER)
        self.m_NoteBookEdit2.AddPage(self.m_Editor2, "untitled")

        self.m_SplitEdit.SetMinimumPaneSize(20)
        self.m_SplitEdit.SplitVertically(self.m_NoteBookEdit, self.m_NoteBookEdit2, 150)
        self.m_SplitEdit.SetSashPosition(100)

        win = wxSashLayoutWindow(self, self.ID_WINDOW_BOTTOM, wxDefaultPosition, wxSize(200, 30), wxNO_BORDER |wxSW_3D)
        win.SetDefaultSize(wxSize(1000, 100))
        win.SetOrientation(wxLAYOUT_HORIZONTAL)
        win.SetAlignment(wxLAYOUT_BOTTOM)
        win.SetSashVisible(wxSASH_TOP, true)
        self.m_BottomWindow = win

        self.m_WinResult=wxKWinResult(self.m_BottomWindow, id=-1, style=wxNB_BOTTOM| wxNO_3D |wxSIMPLE_BORDER )

        win =  wxSashLayoutWindow(self, self.ID_WINDOW_LEFT, wxDefaultPosition, wxSize(200, 30), wxNO_BORDER )
        win.SetDefaultSize(wxSize(120, 1000))
        win.SetOrientation(wxLAYOUT_VERTICAL)
        win.SetAlignment(wxLAYOUT_LEFT)
        win.SetSashVisible(wxSASH_RIGHT, TRUE)
        self.m_LeftWindow = win

        self.m_WinSupp=wxKWinSupp(self.m_LeftWindow, -1, wxDefaultPosition, wxSize(80,180), wxNO_3D|wxSIMPLE_BORDER )

    #---------------------------------------------------------------------------
    def OnSize(self, event):
        wxLayoutAlgorithm().LayoutWindow(self, self.m_SplitEdit)
    #---------------------------------------------------------------------------
    def OnSashDrag(self, event):
        if event.GetDragStatus() == wxSASH_STATUS_OUT_OF_RANGE:
            return

        eID = event.GetId()
        if eID == self.ID_WINDOW_LEFT:
            self.m_LeftWindow.SetDefaultSize(wxSize(event.GetDragRect().width, 1000))
        elif eID == self.ID_WINDOW_BOTTOM:
            self.m_BottomWindow.SetDefaultSize(wxSize(1000, event.GetDragRect().height))

        wxLayoutAlgorithm().LayoutWindow(self, self.m_SplitEdit)
        self.m_SplitEdit.Refresh()
    #---------------------------------------------------------------------------
    def EmptyHandler(self, evt):
        pass
