﻿import sys
print hasattr(sys, "setdefaultencoding")
if hasattr(sys, "setdefaultencoding"):
    print sys.getfilesystemencoding()
    sys.setdefaultencoding('utf-8')

import wx
import wx.html
import subprocess
import wmsolution

class WmHelperAbout(wx.Dialog):
    text = '''
    <html>
    <body bgcolor="#ACAA60">
    <p>
    <b>사용방법</b>
    <ol>
    <li>파일 메뉴에서 '지뢰찾기 실행...' 버튼을 눌러 지뢰찾기를 실행합니다.</li>
    <li>지뢰를 찾다가 힘들면 '도와줘' 버튼을 누르면 내부 알고리즘에 따라 자동으로 지뢰를 찾습니다.</li>
    <li>'재시작'을 체크하고 '도와줘' 버튼을 누르면 진행중인 지뢰찾기를 중단하고 재시작 후 지뢰를 찾습니다.</li>
    <li>지뢰찾기 신기록을 세워보세요.
    </ol>
    </p>
    <p>http://kldp.net/projects/wmhelper/</p>
    <p>지뢰찾기 도우미 v1.0</p>
    <p>2007. 1. 22. Kdaejin</p>
    </body>
    </html>
    '''

    def __init__(self, parent):
        wx.Dialog.__init__(self, parent, -1, '도움말',
                           size=(440, 350))

        html = wx.html.HtmlWindow(self)
        html.SetPage(self.text)
        button = wx.Button(self, wx.ID_OK, "확인")

        sizer = wx.BoxSizer(wx.VERTICAL)
        sizer.Add(html, 1, wx.EXPAND|wx.ALL, 5)
        sizer.Add(button, 0, wx.ALIGN_CENTER|wx.ALL, 5)

        self.SetSizer(sizer)
        self.Layout()

class wmhelperFrame(wx.Frame):

    def __init__(self, parent, id):
        wx.Frame.__init__(self, parent, id, '지뢰찾기 도우미',
                          size=(210, 130))
        panel = wx.Panel(self)

        menu = wx.Menu()
        mineMenu = menu.Append(-1, "지뢰찾기 실행...")
        helpMenu = menu.Append(-1, "도움말")
        menu.AppendSeparator()
        exitMenu = menu.Append(-1, "종료")
        self.Bind(wx.EVT_MENU, self.OnMine, mineMenu)
        self.Bind(wx.EVT_MENU, self.OnHelp, helpMenu)
        self.Bind(wx.EVT_MENU, self.OnExit, exitMenu)
        
        menuBar = wx.MenuBar()
        menuBar.Append(menu, "파일")
        self.SetMenuBar(menuBar)
        
        button = wx.Button(panel, label="도와줘!", pos=(100, 10),
                           size=(90,50))
        self.checkbox = wx.CheckBox(panel, -1, "재시작", (20, 25), (60, 20))
        self.Bind(wx.EVT_BUTTON, self.OnFindMine, button)

    def OnMine(self, event):
        subprocess.Popen('winmine')
        
    def OnHelp(self, event):
        dlg = WmHelperAbout(self)
        dlg.ShowModal()
        dlg.Destroy()
    
    def OnExit(self, event):
        self.Close()

    def OnFindMine(self, event):
        wmsolution.runWmsolution(self.checkbox.GetValue())

if __name__ == '__main__':
    app = wx.PySimpleApp()
    frame = wmhelperFrame(parent=None, id=-1)
    frame.Show()
    app.MainLoop()

