#include <windows.h>
#include <malloc.h>
#include "Python.h"

static PyObject *ErrorObject;
const SIZE szCell = {16,16};	//  ũ
const POINT ptTL = { 12, 55 };	// TopLeft Point of Grid
static SIZE szNum;				// Cell ,  
static enum STATUSFACE { SF_SMILE, SF_FAIL, SF_SUCCESS, SF_TOTAL };	// "status_face.bmp"  ¾ƾ Ѵ.

static BOOL bmpcmp(BITMAP* pBit1, POINT pt1, BITMAP* pBit2, POINT pt2, SIZE s)
// ȼ Ʈ Ʈ  ,  Ʈ Ư   ġϴ  
{
	int i;
	int nOffset1, nOffset2;
	int nBytesPixel;	// ȼ Ʈ
	RECT rtM, rtS;	// ӽ 簢, Main, Sub
	rtM.left = rtM.top = 0;

	// Է ͸ ϱ  񱳰 ȿ ˻
	if( pBit1->bmPlanes != pBit2->bmPlanes )
		return FALSE;
	if( pBit1->bmBitsPixel != pBit2->bmBitsPixel || pBit1->bmBitsPixel % 8 != 0 )
		return FALSE;	// ȼƮ Ʈ   ۵Ѵ.
	else
		nBytesPixel = pBit1->bmBitsPixel / 8;
	
	//  RECT BITMAP Ÿ   ʴ ˻
	rtM.right = pBit1->bmWidth;
	rtM.bottom = pBit1->bmHeight;
	rtS.left = pt1.x;
	rtS.top = pt1.y;
	rtS.right = pt1.x + s.cx;
	rtS.bottom = pt1.y + s.cy;
	UnionRect(&rtS, &rtM, &rtS);
	if( !EqualRect(&rtS, &rtM) )
		return FALSE;
	rtM.right = pBit2->bmWidth;
	rtM.bottom = pBit2->bmHeight;
	rtS.left = pt2.x;
	rtS.top = pt2.y;
	rtS.right = pt2.x + s.cx;
	rtS.bottom = pt2.y + s.cy;
	UnionRect(&rtS, &rtM, &rtS);
	if( !EqualRect(&rtS, &rtM) )
		return FALSE;
	
	// Ʈ Ʈ 
	for( i=0 ; i<s.cy ; i++ )
	{
		nOffset1 = pt1.x * nBytesPixel + (pt1.y + i) * pBit1->bmWidthBytes;
		nOffset2 = pt2.x * nBytesPixel + (pt2.y + i) * pBit2->bmWidthBytes;
		if( 0 != memcmp( (LPVOID)((PBYTE)pBit1->bmBits + nOffset1), (LPVOID)((PBYTE)pBit2->bmBits + nOffset2), s.cx * nBytesPixel ) )
			return FALSE;
	}
	
	return TRUE;
}

static int getstatusface(BITMAP* pMainBit)
{
	int i;
	BITMAP bit;
	HBITMAP hBit;
	POINT pt;			// SF ġ
	SIZE sz = {20,20};	// SF ũ
	POINT ptTemp;

	pt.x = pMainBit->bmWidth / 2 - 8;	// ߰ġ ϱ
	pt.y = 18;	// Ʈ Ͽ   
	
	// Ʈ Ϸκ ҷ
	hBit = (HBITMAP)LoadImage(NULL,"status_face.bmp",IMAGE_BITMAP,0,0,LR_LOADFROMFILE);
	GetObject(hBit, sizeof(BITMAP), &bit);
	bit.bmBits = calloc(bit.bmHeight, bit.bmWidthBytes);
	GetBitmapBits(hBit, bit.bmHeight*bit.bmWidthBytes, bit.bmBits);

	// Ʈ 񱳷 SF 
	for(i=0 ; i<SF_TOTAL ; i++)
	{
		ptTemp.x = i * sz.cx;
		ptTemp.y = 0;
		if( bmpcmp(pMainBit, pt, &bit, ptTemp, sz) )
			break;
	}

	// ޷θ , Ʈ ı
	free(bit.bmBits);
	DeleteObject(hBit);

	return i;
}

static int getminecount(BITMAP* pMainBit)
{
	int i,j,k;
	BITMAP bit;
	HBITMAP hBit;
	const POINT pt = {17,16};	// MC ġ
	const SIZE sz = {13,23};	// MC ϳ ũ
	const int nFigure = 3;		// MC ڸ
	POINT ptTemp, ptTempMain;
	int nMC = 0;
	enum MINECOUNT { MC_0, MC_1, MC_2, MC_3, MC_4, MC_5,
		MC_6, MC_7, MC_8, MC_9, MC_TOTAL };	// "mine_count.bmp"  ¾ƾ Ѵ.

	// Ʈ Ϸκ ҷ
	hBit = (HBITMAP)LoadImage(NULL,"mine_count.bmp",IMAGE_BITMAP,0,0,LR_LOADFROMFILE);
	GetObject(hBit, sizeof(BITMAP), &bit);
	bit.bmBits = calloc(bit.bmHeight, bit.bmWidthBytes);
	GetBitmapBits(hBit, bit.bmHeight*bit.bmWidthBytes, bit.bmBits);

	// Ʈ 񱳷 MC 
	for(i=0 ; i<nFigure ; i++)
	{
		for(j=0 ; j<MC_TOTAL ; j++)
		{
			ptTemp.x = j * sz.cx;
			ptTemp.y = 0;
			ptTempMain.x = pt.x + i * sz.cx;
			ptTempMain.y = pt.y;
			if( bmpcmp(pMainBit, ptTempMain, &bit, ptTemp, sz) )
				break;
		}
		for(k=0 ; k<(nFigure-i-1) ; k++)
			j *= 10;
		nMC += j;
	}

	// ޷θ , Ʈ ı
	free(bit.bmBits);
	DeleteObject(hBit);

	return nMC;
}

static PyObject* getgridcell(BITMAP* pMainBit)
{
	PyObject* ctuple;	// cell tuple
	int i,j,k;
	BITMAP bit;	// Grid Cell Ʈ
	HBITMAP hBit;
	POINT pt;	//   ġ
	POINT ptTemp;
	
	enum GRIDCELL { GC_BLANK, GC_MINE, GC_QUESTION, GC_REVEALED, GC_1, GC_2, GC_3, GC_4,
		GC_5, GC_6, GC_7, GC_8, GC_BOOM1, GC_BOOM2, GC_BOOM3, GC_TOTAL };	// "grid_cell.bmp"  ¾ƾ Ѵ.

	
	// Ʈ Ϸκ ҷ
	hBit = (HBITMAP)LoadImage(NULL,"grid_cell.bmp",IMAGE_BITMAP,0,0,LR_LOADFROMFILE);
	GetObject(hBit, sizeof(BITMAP), &bit);
	bit.bmBits = calloc(bit.bmHeight, bit.bmWidthBytes);
	GetBitmapBits(hBit, bit.bmHeight*bit.bmWidthBytes, bit.bmBits);

	// Ʈ 񱳷    ľϱ
	ctuple = PyTuple_New(szNum.cx * szNum.cy);
	for(i=0 ; i<szNum.cy ; i++)
	 for(j=0 ; j<szNum.cx ; j++)
	{
		pt.x = j * szCell.cx + ptTL.x;
		pt.y = i * szCell.cy + ptTL.y;
		for(k=0 ; k<GC_TOTAL ; k++)
		{
			ptTemp.x = k * szCell.cx;
			ptTemp.y = 0;
			if( bmpcmp(pMainBit, pt, &bit, ptTemp, szCell) )
				break;
		}
		PyTuple_SetItem(ctuple, i*szNum.cx + j, Py_BuildValue("i", k));
	}

	// ޷θ , Ʈ ı
	free(bit.bmBits);
	DeleteObject(hBit);

	return ctuple;
}

static PyObject* winmine_getdata(PyObject *self, PyObject *args)
// ãâ    3   Ʃ  ´.
// Status Face : ã ۹ư 
// Num Size : ,   ũ Ʃ
// Cell Data :    ȭ Ʃ
{
	PyObject* rtuple;	// result tuple
	PyObject* tblank;	// temporary tuple
	BITMAP bit;			// ã ȭ ĸؼ   Ʈ
	HBITMAP hBit;		// ã Ʈ ڵ
	HBITMAP hOldBitmap;
	HDC hMemDC, hSrcDC;	// ȭ ĸϱ  ӽ DC
	HWND hWnd;			// ã â ڵ
	RECT rt;			// ã â Ŭ̾Ʈ 簢
	int nSF, nMC;		// Status Face, Mine Count
	enum ResultItem { RI_STATUSFACE, RI_MINECOUNT, RI_NUMSIZE, RI_CELLDATA, RI_TOTAL };	//  ׸

	rtuple = PyTuple_New(RI_TOTAL);
	tblank = PyTuple_New(0);

	hWnd = FindWindow(NULL, " ã");
	
	if( hWnd == NULL )
	{
		PyTuple_SetItem(rtuple, RI_STATUSFACE, Py_BuildValue("i", SF_TOTAL));
		PyTuple_SetItem(rtuple, RI_MINECOUNT, Py_BuildValue("i", 0));
		PyTuple_SetItem(rtuple, RI_NUMSIZE, tblank);
		PyTuple_SetItem(rtuple, RI_CELLDATA, tblank);
	}
	else
	{
		GetClientRect(hWnd, &rt);

		// ã â ȭ ĸؼ Ʈʿ 
		hSrcDC = GetDC(hWnd);
		hMemDC = CreateCompatibleDC(hSrcDC);
		hBit = CreateCompatibleBitmap(hSrcDC,
				rt.right-rt.left, rt.bottom-rt.top);
		hOldBitmap = (HBITMAP)SelectObject(hMemDC, hBit);
		BitBlt(hMemDC,0,0,rt.right-rt.left,rt.bottom-rt.top,
			hSrcDC,0,0,SRCCOPY);
		SelectObject(hMemDC,hOldBitmap);
		DeleteDC(hMemDC);
		ReleaseDC(hWnd, hSrcDC);

		GetObject(hBit, sizeof(BITMAP), &bit);	// Ʈ ü 
		bit.bmBits = calloc(bit.bmHeight, bit.bmWidthBytes);
		GetBitmapBits(hBit, bit.bmHeight*bit.bmWidthBytes, bit.bmBits);


		//  Ʃ ۼϱ

		nSF = getstatusface(&bit);	// Status Face 
		PyTuple_SetItem(rtuple, RI_STATUSFACE, Py_BuildValue("i", nSF));
		nMC = getminecount(&bit);	// Mine Count 
		PyTuple_SetItem(rtuple, RI_MINECOUNT, Py_BuildValue("i", nMC));

		if( nSF != SF_SMILE )
		{
			PyTuple_SetItem(rtuple, RI_NUMSIZE, tblank);
			PyTuple_SetItem(rtuple, RI_CELLDATA, tblank);
		}
		else
		{
			//   ԰ 
			szNum.cx = (bit.bmWidth - ptTL.x - 8) / szCell.cx; // 8  
			szNum.cy = (bit.bmHeight - ptTL.y - 8) / szCell.cy; // 8  
			PyTuple_SetItem(rtuple, RI_NUMSIZE, Py_BuildValue("ii", szNum.cx, szNum.cy));
			
			//     
			PyTuple_SetItem(rtuple, RI_CELLDATA, getgridcell(&bit));
		}

		// ޷θ , Ʈ ı
		free(bit.bmBits);
		DeleteObject(hBit);
	}

	return rtuple;
}

static PyObject* winmine_sendmsg(PyObject *self, PyObject *args)
// ġ شϴ  Ŭ(reveal)ϰų Ŭ(mine)ϴ
// ޽ ã â Ѵ.
//   PostMessage ȣϿ '', ƴϸ '' 
{
	char *option;
	int nIndex = 0;	//  ġ ε
	POINT posCell;	//  ġ
	POINT ptClick;	// Ŭ ȼ ġ
	HWND hWnd;		// ã â ڵ
	LPARAM lParam;

	hWnd = FindWindow(NULL, " ã");
	if( hWnd == NULL || (szNum.cx == 0 && szNum.cy == 0) )
		return Py_BuildValue("i", 0);	// â ų    ʾ

	if( !PyArg_ParseTuple(args, "s|i", &option, &nIndex) ) // , 
		return NULL;

	posCell.x = nIndex % szNum.cx;
	posCell.y = nIndex / szNum.cx;
	if( !(posCell.x < szNum.cx && posCell.y < szNum.cy) ) //  ġ  
		return Py_BuildValue("i", 0);

	//   ߽ġ lParam 
	ptClick.x = ptTL.x + posCell.x * szCell.cx + 8;	// 8 ߽  ؼ
	ptClick.y = ptTL.y + posCell.y * szCell.cy + 8;	// 8 ߽  ؼ
	lParam = MAKELPARAM(ptClick.x, ptClick.y);

	// ɼǿ  ޽ Ʈ
	if( strcmp(option, "reveal") == 0 )
	{
		PostMessage(hWnd, WM_LBUTTONDOWN, MK_LBUTTON, lParam);
		PostMessage(hWnd, WM_LBUTTONUP, 0, lParam);
	}
	else if( strcmp(option, "mine") == 0 )
	{
		PostMessage(hWnd, WM_RBUTTONDOWN, MK_RBUTTON, lParam);
		PostMessage(hWnd, WM_RBUTTONUP, 0, lParam);
	}
	else if( strcmp(option, "restart") == 0 )
	{
		PostMessage(hWnd, WM_COMMAND, 0x1FE, 0);	// wID=510 spy++  ˾Ƴ 
									// ?ǥô 0x20F, ÷ǥô 0x211
	}
	else
	{
		return Py_BuildValue("i", 0);
	}

	return Py_BuildValue("i", 1);
}

static struct PyMethodDef winmine_methods[] = {
	{"getdata", winmine_getdata, METH_NOARGS},
	{"sendmsg", winmine_sendmsg, METH_VARARGS},
	{NULL,NULL}
};

void initwinmine()
{
	PyObject *m;
	m = Py_InitModule("winmine", winmine_methods);
	ErrorObject = Py_BuildValue("s", "winmine_error");

	szNum.cx = 0;
	szNum.cy = 0;
}