module win32DEF;

import std.c.windows.windows;

extern (Windows){

	alias HANDLE HHOOK;
	alias uint ULONG_PTR;

	enum {
		WH_KEYBOARD_LL		= 13,
		WH_KEYBOARD		= 2,
		HC_ACTION		= 0,
		KEYEVENTF_KEYUP		= 0x0002,
		INPUT_MOUSE		= 0x00000000,
		INPUT_KEYBOARD		= 0x00000001,
		INPUT_HARDWARE		= 0x00000002,
		KF_UP			= 32768,
		LLKHF_UP		= (KF_UP >> 8),
		MOUSEEVENTF_ABSOLUTE	= 32768,
		MOUSEEVENTF_MOVE	= 1,
		MOUSEEVENTF_LEFTDOWN	= 2,
		MOUSEEVENTF_LEFTUP	= 4
	}

	struct KBDLLHOOKSTRUCT {
		DWORD vkCode;
		DWORD scanCode;
		DWORD flags;
		DWORD time;
		ULONG_PTR dwExtraInfo;
	}

	struct MOUSEINPUT {
		LONG dx;
		LONG dy;
		DWORD mouseData;
		DWORD dwFlags;
		ULONG_PTR dwExtraInfo;
	}
	struct KEYBDINPUT {
		WORD wVk;
		WORD wScan;
		DWORD dwFlags;
		DWORD time;
		ULONG_PTR dwExtraInfo;
	}

	struct HARDWAREINPUT {
		DWORD uMsg;
		WORD wParamL;
		WORD wParamH;
	}

	struct INPUT {
		// Note: <Shawn> sizeof = 28
		int type;
		union {
			MOUSEINPUT mi; 
			KEYBDINPUT ki;
			HARDWAREINPUT hi;
		}
	}alias INPUT* PINPUT, LPINPUT;

	HHOOK SetWindowsHookExA(
		int idHook,        // type of hook to install
		HOOKPROC lpfn,     // address of hook procedure
		HINSTANCE hMod,    // handle to application instance
		DWORD dwThreadId   // identity of thread to install hook for
	);

	BOOL UnhookWindowsHookEx(
	HHOOK hhk   // handle to hook procedure to remove
	);

	LRESULT CallNextHookEx(
		HHOOK hhk,      // handle to current hook
		int nCode,      // hook code passed to hook procedure
		WPARAM wParam,  // value passed to hook procedure
		LPARAM lParam   // value passed to hook procedure
	);

	UINT SendInput(          
		UINT nInputs,
		LPINPUT pInputs,
		int cbSize
	);

	void RtlMoveMemory(void* Destination, void* Source, DWORD Length);

	SHORT VkKeyScanA(char ch);
	SHORT VkKeyScanW(wchar ch);

	alias VkKeyScanA VkKeyScan;
}