// Scourge.cpp : DLL  α׷   մϴ.
//

#include "stdafx.h"
#include "Scourge.h"

#pragma	data_seg(".GHook")
HWND hWndServer = NULL;
#pragma data_seg()
#pragma comment(linker, "/section:.GHook,rws")

UINT uOpt, uKey[6];
HINSTANCE	hInst;
HHOOK		hook;

static LRESULT CALLBACK MsgHook(UINT nCode, WPARAM wParam, LPARAM lParam);

BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
	switch (ul_reason_for_call)
	{
	case DLL_PROCESS_ATTACH:	
		hInst = (HINSTANCE)hModule;
		break;	
	case DLL_THREAD_ATTACH:		break;
	case DLL_THREAD_DETACH:		break;
	case DLL_PROCESS_DETACH:	
		if (hWndServer) UninstallHook(hWndServer);
		break;
	}
    return TRUE;
}
SCOURGE_API void SetupKeyOpt(UINT u7, UINT u8, UINT u4, UINT u5, UINT u1, UINT u2, UINT opt) {
	uOpt = opt;
	uKey[0] = u7;
	uKey[1] = u8;
	uKey[2] = u4;
	uKey[3] = u5;
	uKey[4] = u1;
	uKey[5] = u2;
}

SCOURGE_API BOOL InstallHook(HWND hWnd)
{
	if ( hWndServer != NULL )
		return FALSE;

	hook = ::SetWindowsHookEx( WH_KEYBOARD_LL, (HOOKPROC)MsgHook, hInst, 0 );
	if ( hook != NULL ) // Success !!
	{
		hWndServer = hWnd;
		return TRUE;
	}

	return FALSE; // FAIL !!
}	

SCOURGE_API BOOL UninstallHook(HWND hWnd)
{
	if ( hWnd != hWndServer || hWnd == NULL )
		return FALSE;

	BOOL unhooked = ::UnhookWindowsHookEx(hook);
	
	if ( unhooked )
		hWndServer = NULL;
	
	return unhooked;
}


#define _SHIFT 0x800
#define _ALT   0x400
#define _CTRL  0x200

BOOL CheckAndSend(int nSendKey/*  Ű */, UINT uKeyOpt/* ¾ Ű*/, DWORD vkCode/*Էµ Ű*/, WPARAM wParam) {
	if ((uKeyOpt & 0xFF) != vkCode) return FALSE;

	if (wParam == WM_CHAR || wParam == WM_KEYDOWN) return FALSE;	
	
	SHORT keyState;

	keyState = GetKeyState(VK_SHIFT);
	if (uKeyOpt & _SHIFT) { // shift ɼ 
		if (keyState >= 0) // shift ȴ
			return FALSE;
	} else { // shift ɼ 
		if (keyState < 0) // shift 
			return FALSE;
	}

	if (wParam != WM_KEYUP && wParam != WM_SYSKEYUP) return TRUE;

	if (uKeyOpt & _ALT) { // alt ɼ 
		if (GetKeyState(VK_MENU) >= 0) // alt ȴ
			return FALSE;
		INPUT Input[4];
		::ZeroMemory(Input, sizeof(INPUT) * 4);		
		Input[0].type = INPUT_KEYBOARD; Input[0].ki.wVk = VK_MENU; 
		Input[1].type = INPUT_KEYBOARD; Input[1].ki.wVk = VK_MENU; Input[1].ki.dwFlags = KEYEVENTF_KEYUP;
		Input[2].type = INPUT_KEYBOARD; Input[2].ki.wVk = VK_MENU; 
		Input[3].type = INPUT_KEYBOARD; Input[3].ki.wVk = VK_MENU; Input[3].ki.dwFlags = KEYEVENTF_KEYUP;

		// altŰ   óϿ Ű ¸ 
		// ι ؾ  óǾ. ?
		SendInput(4, Input, sizeof(INPUT)); 
	}

	if (uKeyOpt & _CTRL) { // ctrl ɼ 
		if (GetKeyState(VK_CONTROL) >= 0) // ctrl ȴ
			return FALSE;
		INPUT Input[2];
		::ZeroMemory(Input, sizeof(INPUT) * 2);		
		Input[0].type = INPUT_KEYBOARD; Input[0].ki.wVk = VK_CONTROL; 
		Input[1].type = INPUT_KEYBOARD; Input[1].ki.wVk = VK_CONTROL; Input[1].ki.dwFlags = KEYEVENTF_KEYUP;

		// ctrlŰ   óϿ Ű ¸ 
		SendInput(2, Input, sizeof(INPUT)); 
	}
	

	INPUT Input[2];
	::ZeroMemory(Input, sizeof(INPUT) * 2);
	Input[0].type = INPUT_KEYBOARD; Input[0].ki.wVk = nSendKey; 
	Input[1].type = INPUT_KEYBOARD; Input[1].ki.wVk = nSendKey; Input[1].ki.dwFlags = KEYEVENTF_KEYUP;

	SendInput(2, Input, sizeof(INPUT));

	return TRUE; // ó
}

static LRESULT CALLBACK MsgHook(UINT nCode, WPARAM wParam, LPARAM lParam) {
	if (nCode == HC_ACTION) {
		KBDLLHOOKSTRUCT *pkbhs = (KBDLLHOOKSTRUCT *)lParam;	
		if (uOpt & 0x01 && pkbhs->vkCode == VK_LWIN) return 1;				
		
		if (uKey[0] && CheckAndSend(VK_NUMPAD7, uKey[0], pkbhs->vkCode, wParam))
			return 1;
		if (uKey[1] && CheckAndSend(VK_NUMPAD8, uKey[1], pkbhs->vkCode, wParam))
			return 1;
		if (uKey[2] && CheckAndSend(VK_NUMPAD4, uKey[2], pkbhs->vkCode, wParam))
			return 1;
		if (uKey[3] && CheckAndSend(VK_NUMPAD5, uKey[3], pkbhs->vkCode, wParam))
			return 1;
		if (uKey[4] && CheckAndSend(VK_NUMPAD1, uKey[4], pkbhs->vkCode, wParam))
			return 1;
		if (uKey[5] && CheckAndSend(VK_NUMPAD2, uKey[5], pkbhs->vkCode, wParam))
			return 1;
	} 

	return CallNextHookEx(hook, nCode, wParam, lParam);
}

