/******************************************************************************
** $Id: opcua_enumparser.c 21864 2007-05-21 18:08:47Z jake $
**
** Copyright (C) 2006-2007 ascolab GmbH. All Rights Reserved.
** Web: http://www.ascolab.com
** 
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
** 
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
** 
** Project: OpcUa Wireshark Plugin
**
** Description: OpcUa Enum Type Parser
**
** This file was autogenerated on 8.5.2007 18:53:26.
** DON'T MODIFY THIS FILE!
**
******************************************************************************/

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <glib.h>
#include <epan/packet.h>

#include "opcua_enumparser.h"


/** NodeClass enum table */
static const value_string g_NodeClassTable[] = {
  { 0, "Node" },
  { 1, "Object" },
  { 2, "Variable" },
  { 4, "Method" },
  { 8, "ObjectType" },
  { 16, "VariableType" },
  { 32, "ReferenceType" },
  { 64, "DataType" },
  { 128, "View" },
  { 0, NULL }
};
static int hf_opcua_NodeClass = -1;

void parseNodeClass(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
	proto_tree_add_item(tree, hf_opcua_NodeClass, tvb, *pOffset, 4, TRUE); *pOffset+=4;
}

/** IdType enum table */
static const value_string g_IdTypeTable[] = {
  { 0, "Numeric" },
  { 1, "String" },
  { 2, "Uri" },
  { 3, "Guid" },
  { 4, "Opaque" },
  { 0, NULL }
};
static int hf_opcua_IdType = -1;

void parseIdType(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
	proto_tree_add_item(tree, hf_opcua_IdType, tvb, *pOffset, 4, TRUE); *pOffset+=4;
}

/** MessageSecurityMode enum table */
static const value_string g_MessageSecurityModeTable[] = {
  { 0, "None" },
  { 1, "Sign" },
  { 2, "SignAndEncrypt" },
  { 0, NULL }
};
static int hf_opcua_MessageSecurityMode = -1;

void parseMessageSecurityMode(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
	proto_tree_add_item(tree, hf_opcua_MessageSecurityMode, tvb, *pOffset, 4, TRUE); *pOffset+=4;
}

/** UserTokenType enum table */
static const value_string g_UserTokenTypeTable[] = {
  { 0, "Default" },
  { 1, "UserName" },
  { 2, "Certificate" },
  { 3, "IssuedToken" },
  { 0, NULL }
};
static int hf_opcua_UserTokenType = -1;

void parseUserTokenType(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
	proto_tree_add_item(tree, hf_opcua_UserTokenType, tvb, *pOffset, 4, TRUE); *pOffset+=4;
}

/** ServerDescriptionType enum table */
static const value_string g_ServerDescriptionTypeTable[] = {
  { 0, "Standard" },
  { 1, "Discovery" },
  { 0, NULL }
};
static int hf_opcua_ServerDescriptionType = -1;

void parseServerDescriptionType(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
	proto_tree_add_item(tree, hf_opcua_ServerDescriptionType, tvb, *pOffset, 4, TRUE); *pOffset+=4;
}

/** SecurityTokenRequestType enum table */
static const value_string g_SecurityTokenRequestTypeTable[] = {
  { 0, "Issue" },
  { 1, "Renew" },
  { 0, NULL }
};
static int hf_opcua_SecurityTokenRequestType = -1;

void parseSecurityTokenRequestType(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
	proto_tree_add_item(tree, hf_opcua_SecurityTokenRequestType, tvb, *pOffset, 4, TRUE); *pOffset+=4;
}

/** ComplianceLevel enum table */
static const value_string g_ComplianceLevelTable[] = {
  { 0, "Untested" },
  { 1, "Partial" },
  { 2, "SelfTested" },
  { 3, "Certified" },
  { 0, NULL }
};
static int hf_opcua_ComplianceLevel = -1;

void parseComplianceLevel(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
	proto_tree_add_item(tree, hf_opcua_ComplianceLevel, tvb, *pOffset, 4, TRUE); *pOffset+=4;
}

/** RedundancySupport enum table */
static const value_string g_RedundancySupportTable[] = {
  { 1, "None" },
  { 2, "Cold" },
  { 3, "Warm" },
  { 4, "Hot" },
  { 0, NULL }
};
static int hf_opcua_RedundancySupport = -1;

void parseRedundancySupport(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
	proto_tree_add_item(tree, hf_opcua_RedundancySupport, tvb, *pOffset, 4, TRUE); *pOffset+=4;
}

/** ServerState enum table */
static const value_string g_ServerStateTable[] = {
  { 1, "Running" },
  { 2, "Failed" },
  { 3, "NoConfiguration" },
  { 4, "Suspended" },
  { 5, "Shutdown" },
  { 6, "Test" },
  { 7, "CommunicationFault" },
  { 8, "Unknown" },
  { 0, NULL }
};
static int hf_opcua_ServerState = -1;

void parseServerState(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
	proto_tree_add_item(tree, hf_opcua_ServerState, tvb, *pOffset, 4, TRUE); *pOffset+=4;
}

/** ExceptionDeviationType enum table */
static const value_string g_ExceptionDeviationTypeTable[] = {
  { 1, "AbsoluteValue" },
  { 2, "PercentOfRange" },
  { 3, "PercentOfValue" },
  { 0, NULL }
};
static int hf_opcua_ExceptionDeviationType = -1;

void parseExceptionDeviationType(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
	proto_tree_add_item(tree, hf_opcua_ExceptionDeviationType, tvb, *pOffset, 4, TRUE); *pOffset+=4;
}

/** ColorsDataType enum table */
static const value_string g_ColorsDataTypeTable[] = {
  { 1, "Red" },
  { 2, "Orange" },
  { 3, "Yellow" },
  { 4, "Green" },
  { 5, "Blue" },
  { 6, "DarkBlue" },
  { 7, "Violet" },
  { 0, NULL }
};
static int hf_opcua_ColorsDataType = -1;

void parseColorsDataType(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
	proto_tree_add_item(tree, hf_opcua_ColorsDataType, tvb, *pOffset, 4, TRUE); *pOffset+=4;
}

/** DiagnosticsMasks enum table */
static const value_string g_DiagnosticsMasksTable[] = {
  { 1, "ServiceSymbolicId" },
  { 2, "ServiceLocalizedText" },
  { 4, "ServiceAdditionalInfo" },
  { 8, "ServiceInnerStatusCode" },
  { 16, "ServiceInnerDiagnostics" },
  { 3, "ServiceSymbolicIdAndText" },
  { 15, "ServiceNoInnerStatus" },
  { 31, "ServiceAll" },
  { 32, "OperationSymbolicId" },
  { 64, "OperationLocalizedText" },
  { 128, "OperationAdditionalInfo" },
  { 256, "OperationInnerStatusCode" },
  { 512, "OperationInnerDiagnostics" },
  { 96, "OperationSymbolicIdAndText" },
  { 224, "OperationNoInnerStatus" },
  { 992, "OperationAll" },
  { 33, "SymbolicId" },
  { 66, "LocalizedText" },
  { 132, "AdditionalInfo" },
  { 264, "InnerStatusCode" },
  { 528, "InnerDiagnostics" },
  { 99, "SymbolicIdAndText" },
  { 239, "NoInnerStatus" },
  { 1023, "All" },
  { 0, NULL }
};
static int hf_opcua_DiagnosticsMasks = -1;

void parseDiagnosticsMasks(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
	proto_tree_add_item(tree, hf_opcua_DiagnosticsMasks, tvb, *pOffset, 4, TRUE); *pOffset+=4;
}

/** EnumeratedTestType enum table */
static const value_string g_EnumeratedTestTypeTable[] = {
  { 1, "Red" },
  { 4, "Yellow" },
  { 5, "Green" },
  { 0, NULL }
};
static int hf_opcua_EnumeratedTestType = -1;

void parseEnumeratedTestType(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
	proto_tree_add_item(tree, hf_opcua_EnumeratedTestType, tvb, *pOffset, 4, TRUE); *pOffset+=4;
}

/** BrowseDirection enum table */
static const value_string g_BrowseDirectionTable[] = {
  { 1, "Forward" },
  { 2, "Inverse" },
  { 3, "Both" },
  { 0, NULL }
};
static int hf_opcua_BrowseDirection = -1;

void parseBrowseDirection(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
	proto_tree_add_item(tree, hf_opcua_BrowseDirection, tvb, *pOffset, 4, TRUE); *pOffset+=4;
}

/** FilterOperator enum table */
static const value_string g_FilterOperatorTable[] = {
  { 1, "Equals" },
  { 2, "IsNull" },
  { 3, "GreaterThan" },
  { 4, "LessThan" },
  { 5, "GreaterThanOrEqual" },
  { 6, "LessThanOrEqual" },
  { 7, "Like" },
  { 8, "Not" },
  { 9, "Between" },
  { 10, "InList" },
  { 11, "And" },
  { 12, "Or" },
  { 13, "InView" },
  { 14, "OfType" },
  { 15, "RelatedTo" },
  { 0, NULL }
};
static int hf_opcua_FilterOperator = -1;

void parseFilterOperator(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
	proto_tree_add_item(tree, hf_opcua_FilterOperator, tvb, *pOffset, 4, TRUE); *pOffset+=4;
}

/** TimestampsToReturn enum table */
static const value_string g_TimestampsToReturnTable[] = {
  { 1, "Source" },
  { 2, "Server" },
  { 3, "Both" },
  { 4, "Neither" },
  { 0, NULL }
};
static int hf_opcua_TimestampsToReturn = -1;

void parseTimestampsToReturn(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
	proto_tree_add_item(tree, hf_opcua_TimestampsToReturn, tvb, *pOffset, 4, TRUE); *pOffset+=4;
}

/** MonitoringMode enum table */
static const value_string g_MonitoringModeTable[] = {
  { 0, "Disabled" },
  { 1, "Sampling" },
  { 2, "Reporting" },
  { 0, NULL }
};
static int hf_opcua_MonitoringMode = -1;

void parseMonitoringMode(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
	proto_tree_add_item(tree, hf_opcua_MonitoringMode, tvb, *pOffset, 4, TRUE); *pOffset+=4;
}

/** DataChangeTrigger enum table */
static const value_string g_DataChangeTriggerTable[] = {
  { 0, "Status" },
  { 1, "StatusValue" },
  { 2, "StatusValueTimestamp" },
  { 0, NULL }
};
static int hf_opcua_DataChangeTrigger = -1;

void parseDataChangeTrigger(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
	proto_tree_add_item(tree, hf_opcua_DataChangeTrigger, tvb, *pOffset, 4, TRUE); *pOffset+=4;
}

/** DeadbandType enum table */
static const value_string g_DeadbandTypeTable[] = {
  { 0, "None" },
  { 1, "Absolute" },
  { 2, "Percentage" },
  { 0, NULL }
};
static int hf_opcua_DeadbandType = -1;

void parseDeadbandType(proto_tree *tree, tvbuff_t *tvb, gint *pOffset)
{
	proto_tree_add_item(tree, hf_opcua_DeadbandType, tvb, *pOffset, 4, TRUE); *pOffset+=4;
}

/** header field definitions */
static hf_register_info hf[] =
{
    { &hf_opcua_NodeClass,
    {  "NodeClass", "", FT_UINT32, BASE_HEX,  VALS(g_NodeClassTable), 0x0, "", HFILL }
    },
    { &hf_opcua_IdType,
    {  "IdType", "", FT_UINT32, BASE_HEX,  VALS(g_IdTypeTable), 0x0, "", HFILL }
    },
    { &hf_opcua_MessageSecurityMode,
    {  "MessageSecurityMode", "", FT_UINT32, BASE_HEX,  VALS(g_MessageSecurityModeTable), 0x0, "", HFILL }
    },
    { &hf_opcua_UserTokenType,
    {  "UserTokenType", "", FT_UINT32, BASE_HEX,  VALS(g_UserTokenTypeTable), 0x0, "", HFILL }
    },
    { &hf_opcua_ServerDescriptionType,
    {  "ServerDescriptionType", "", FT_UINT32, BASE_HEX,  VALS(g_ServerDescriptionTypeTable), 0x0, "", HFILL }
    },
    { &hf_opcua_SecurityTokenRequestType,
    {  "SecurityTokenRequestType", "", FT_UINT32, BASE_HEX,  VALS(g_SecurityTokenRequestTypeTable), 0x0, "", HFILL }
    },
    { &hf_opcua_ComplianceLevel,
    {  "ComplianceLevel", "", FT_UINT32, BASE_HEX,  VALS(g_ComplianceLevelTable), 0x0, "", HFILL }
    },
    { &hf_opcua_RedundancySupport,
    {  "RedundancySupport", "", FT_UINT32, BASE_HEX,  VALS(g_RedundancySupportTable), 0x0, "", HFILL }
    },
    { &hf_opcua_ServerState,
    {  "ServerState", "", FT_UINT32, BASE_HEX,  VALS(g_ServerStateTable), 0x0, "", HFILL }
    },
    { &hf_opcua_ExceptionDeviationType,
    {  "ExceptionDeviationType", "", FT_UINT32, BASE_HEX,  VALS(g_ExceptionDeviationTypeTable), 0x0, "", HFILL }
    },
    { &hf_opcua_ColorsDataType,
    {  "ColorsDataType", "", FT_UINT32, BASE_HEX,  VALS(g_ColorsDataTypeTable), 0x0, "", HFILL }
    },
    { &hf_opcua_DiagnosticsMasks,
    {  "DiagnosticsMasks", "", FT_UINT32, BASE_HEX,  VALS(g_DiagnosticsMasksTable), 0x0, "", HFILL }
    },
    { &hf_opcua_EnumeratedTestType,
    {  "EnumeratedTestType", "", FT_UINT32, BASE_HEX,  VALS(g_EnumeratedTestTypeTable), 0x0, "", HFILL }
    },
    { &hf_opcua_BrowseDirection,
    {  "BrowseDirection", "", FT_UINT32, BASE_HEX,  VALS(g_BrowseDirectionTable), 0x0, "", HFILL }
    },
    { &hf_opcua_FilterOperator,
    {  "FilterOperator", "", FT_UINT32, BASE_HEX,  VALS(g_FilterOperatorTable), 0x0, "", HFILL }
    },
    { &hf_opcua_TimestampsToReturn,
    {  "TimestampsToReturn", "", FT_UINT32, BASE_HEX,  VALS(g_TimestampsToReturnTable), 0x0, "", HFILL }
    },
    { &hf_opcua_MonitoringMode,
    {  "MonitoringMode", "", FT_UINT32, BASE_HEX,  VALS(g_MonitoringModeTable), 0x0, "", HFILL }
    },
    { &hf_opcua_DataChangeTrigger,
    {  "DataChangeTrigger", "", FT_UINT32, BASE_HEX,  VALS(g_DataChangeTriggerTable), 0x0, "", HFILL }
    },
    { &hf_opcua_DeadbandType,
    {  "DeadbandType", "", FT_UINT32, BASE_HEX,  VALS(g_DeadbandTypeTable), 0x0, "", HFILL }
    }
};

/** Register enum types. */
void registerEnumTypes(int proto)
{
    proto_register_field_array(proto, hf, array_length(hf));
}
