/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.whitebear.handler;

import java.awt.Font;
import java.awt.FontMetrics;
import java.util.ArrayList;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import net.kldp.whitebear.common.entity.QueryResult;
import net.kldp.whitebear.common.log.Log;
import net.kldp.whitebear.handler.MainHandler;
import net.kldp.whitebear.handler.QueryResultHandler;
import net.kldp.whitebear.handler.ui.swing.QueryResultTable;
import net.kldp.whitebear.handler.ui.swing.SqlPanel;

public class QueryHandler {
    private boolean isRunning = false;
    private int maxQueryHistorySize = 50;
    private ArrayList queryHistory;
    private QueryResultHandler queryResultHandler = null;
    private MainHandler mainHandler;

    public MainHandler getMainHandler() {
        return this.mainHandler;
    }

    public QueryHandler(MainHandler mainHandler) {
        this.mainHandler = mainHandler;
        this.queryHistory = new ArrayList();
    }

    public void executeQuery(String string, Object object) {
        if (this.isRunning) {
            Log.logger.error((Object)"Query is executing");
            return;
        }
        this.queryResultHandler = new QueryResultHandler(this, object, string);
        this.queryResultHandler.start();
        this.addQuery(string);
    }

    private void addQuery(String string) {
        if (this.queryHistory.size() > this.maxQueryHistorySize) {
            this.queryHistory.remove(this.queryHistory.size() - 1);
        }
        this.queryHistory.add(string);
    }

    private void showQueryResult(QueryResult queryResult) {
        int n;
        Object object = queryResult.getQuerySource();
        SqlPanel sqlPanel = (SqlPanel)object;
        QueryResultTable queryResultTable = sqlPanel.getSqlResultPanel().getQueryResultTable();
        queryResultTable.removeAll();
        DefaultTableModel defaultTableModel = (DefaultTableModel)queryResultTable.getModel();
        Font font = queryResultTable.getTableHeader().getFont();
        FontMetrics fontMetrics = queryResultTable.getFontMetrics(font);
        ArrayList arrayList = queryResult.getColumnNames();
        for (n = 0; n < queryResult.getColumnCount(); ++n) {
            defaultTableModel.addColumn(arrayList.get(n));
        }
        for (n = 0; n < queryResult.getColumnCount(); ++n) {
            TableColumn tableColumn;
            String string = arrayList.get(n).toString();
            int n2 = fontMetrics.stringWidth(string) + 20;
            if (n2 <= (tableColumn = queryResultTable.getColumnModel().getColumn(n)).getWidth()) continue;
            tableColumn.setPreferredWidth(n2);
        }
        ArrayList arrayList2 = queryResult.getDatas();
        for (int i = 0; i < arrayList2.size(); ++i) {
            ArrayList arrayList3 = (ArrayList)arrayList2.get(i);
            defaultTableModel.addRow(arrayList3.toArray());
        }
        sqlPanel.getSqlResultPanel().getJtMsg().setText(queryResult.getMsg());
    }

    private void showErrorMsg(QueryResult queryResult) {
        Object object = queryResult.getQuerySource();
        SqlPanel sqlPanel = (SqlPanel)object;
        QueryResultTable queryResultTable = sqlPanel.getSqlResultPanel().getQueryResultTable();
        queryResultTable.removeAll();
        sqlPanel.getSqlResultPanel().getJtMsg().setText(queryResult.getMsg());
    }

    public void postExecuteQuery(QueryResult queryResult) {
        if (queryResult.getStatus() == QueryResult.STATUS_OK) {
            Log.logger.debug((Object)"QueryResult Status : STATUS_OK");
            this.showQueryResult(queryResult);
        } else if (queryResult.getStatus() == QueryResult.STATUS_ERROR) {
            Log.logger.debug((Object)"QueryResult Status : STATUS_ERROR");
            this.showErrorMsg(queryResult);
        }
        this.setRunning(false);
    }

    public void close() {
        for (int i = 0; i < this.queryHistory.size(); ++i) {
            this.queryHistory.remove(i);
        }
        this.queryHistory = null;
    }

    public void setRunning(boolean bl) {
        this.isRunning = bl;
    }
}

