/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.whitebear.common.config;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import net.kldp.whitebear.common.entity.DbConnectInfo;
import net.kldp.whitebear.common.log.Log;
import net.kldp.whitebear.common.variable.DBTypes;

public class SessionInfoConfig {
    private final String PREFIX = "session";
    private final String SEPERATOR = ".";
    private final String ALLOC_STR = "=";
    private final String SIZE = ".size";
    private final String DBTYPENAME = ".dbTypeName";
    private final String DBNAME = ".dbName";
    private final String HOST = ".host";
    private final String PORT = ".port";
    private final String USERNAME = ".username";
    private final String PASSWORD = ".password";
    private final String sessionInfoFileName = "./conf/sessioninfo.properties";
    private final String backupInfoFileName = "./conf/sessioninfo.properties.bak";
    private Properties sessionInfo;

    private Properties getSessionInfo() {
        if (this.sessionInfo == null) {
            this.sessionInfo = new Properties();
            try {
                FileInputStream fileInputStream = new FileInputStream("./conf/sessioninfo.properties");
                this.sessionInfo.load(fileInputStream);
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {
                Log.logger.error((Object)"Fail to load session info file", (Throwable)iOException);
                return null;
            }
        }
        return this.sessionInfo;
    }

    public ArrayList getDbConnectInfoList() {
        ArrayList<DbConnectInfo> arrayList = null;
        int n = this.getSessionSize();
        for (int i = 0; i < n; ++i) {
            DbConnectInfo dbConnectInfo = this.getDbConnectInfo(i);
            if (dbConnectInfo == null) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<DbConnectInfo>();
            }
            arrayList.add(dbConnectInfo);
        }
        return arrayList;
    }

    public DbConnectInfo getDbConnectInfo(int n) {
        DbConnectInfo dbConnectInfo = null;
        String string = this.sessionInfo.get("session" + n + ".dbTypeName").toString().trim();
        String string2 = this.sessionInfo.get("session" + n + ".dbName").toString().trim();
        String string3 = this.sessionInfo.get("session" + n + ".host").toString().trim();
        String string4 = this.sessionInfo.get("session" + n + ".port").toString().trim();
        String string5 = this.sessionInfo.get("session" + n + ".username").toString().trim();
        String string6 = this.sessionInfo.get("session" + n + ".password").toString().trim();
        try {
            int n2 = DBTypes.getDbType(string);
            if (DBTypes.isCorrectDbType(n2)) {
                dbConnectInfo = new DbConnectInfo();
                dbConnectInfo.setDbtype(n2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            Log.logger.error((Object)"Fail to get dbinfo of session info(wrong dbtype)", (Throwable)numberFormatException);
            return null;
        }
        dbConnectInfo.setDbName(string2);
        dbConnectInfo.setHost(string3);
        dbConnectInfo.setPort(string4);
        dbConnectInfo.setUserName(string5);
        dbConnectInfo.setPassword(string6);
        return dbConnectInfo;
    }

    private int getSessionSize() {
        int n = 0;
        try {
            n = Integer.parseInt(this.getSessionInfo().get("session.size").toString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            Log.logger.error((Object)"Fail to load session info file", (Throwable)numberFormatException);
        }
        return n;
    }

    private boolean backupSessionInfoFile() {
        File file = new File("./conf/sessioninfo.properties");
        File file2 = new File("./conf/sessioninfo.properties.bak");
        if (!file2.delete()) {
            return false;
        }
        file.renameTo(file2);
        return true;
    }

    public synchronized void store() {
        ArrayList arrayList = this.getDbConnectInfoList();
        if (this.getSessionInfo() != null && arrayList != null && arrayList.size() > 0) {
            if (!this.backupSessionInfoFile()) {
                Log.logger.error((Object)"Fail to backup session info");
            }
            try {
                FileWriter fileWriter = new FileWriter("./conf/sessioninfo.properties");
                BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                bufferedWriter.write("session.size=");
                bufferedWriter.write(Integer.toString(arrayList.size()) + "\n");
                bufferedWriter.write("\n");
                for (int i = 0; i < arrayList.size(); ++i) {
                    DbConnectInfo dbConnectInfo = (DbConnectInfo)arrayList.get(i);
                    bufferedWriter.write("session" + i + ".dbTypeName" + "=");
                    bufferedWriter.write(dbConnectInfo.getDbtype() + "\n");
                    bufferedWriter.write("session" + i + ".dbName" + "=");
                    bufferedWriter.write(dbConnectInfo.getDbName() + "\n");
                    bufferedWriter.write("session" + i + ".host" + "=");
                    bufferedWriter.write(dbConnectInfo.getHost() + "\n");
                    bufferedWriter.write("session" + i + ".port" + "=");
                    bufferedWriter.write(dbConnectInfo.getPort() + "\n");
                    bufferedWriter.write("session" + i + ".username" + "=");
                    bufferedWriter.write(dbConnectInfo.getUserName() + "\n");
                    bufferedWriter.write("session" + i + ".password" + "=");
                    bufferedWriter.write(dbConnectInfo.getPassword() + "\n");
                    bufferedWriter.write("\n");
                }
                bufferedWriter.close();
                fileWriter.close();
            }
            catch (IOException iOException) {
                Log.logger.error((Object)"Fail to store session info(IOException)", (Throwable)iOException);
            }
        }
    }
}

