#include "dwindow.h"
#include "dlist.h"
#include "diclog.h"
#include "dstore.h"

extern Node *Rword;
extern Findnode *Rfind;

void help_window()
{
    WINDOW *help;
    help = newwin(11, 40, 7, 10);
    box(help, ACS_VLINE, ACS_HLINE);
    wmove(help, 1, 2);
    wprintw(help, "p : previous page"); 
    wmove(help, 2, 2);
    wprintw(help, "n : next page"); 
    wmove(help, 3, 2);
    wprintw(help, "P : previous word "); 
    wmove(help, 4, 2);
    wprintw(help, "N : Next word "); 
    wmove(help, 5, 2);
    wprintw(help, "f : find word"); 
    wmove(help, 6, 2);
    wprintw(help, "s : save as file"); 
    wmove(help, 7, 2);
    wprintw(help, "O : print"); 
    wmove(help, 8, 2);
    wprintw(help, "q : wdic exit"); 
    wbkgd(help, COLOR_PAIR(1));
    refresh();
    wgetch(help);
    delwin(help);
}

void about_window()
{
    WINDOW *about;
    about = newwin(7, 55, 7, 10);
    box(about, ACS_VLINE, ACS_HLINE);
    wmove(about, 1, 2);
    wprintw(about, "Wdic ver: 2.1"); 
    wmove(about, 2, 2);
    wprintw(about, "Last Date : 2003.12.24"); 
    wmove(about, 3, 2);
    wprintw(about, "Wdic Project Manager :  (s970501@hotmail.com)"); 
    wmove(about, 4, 2);
    wprintw(about, "Wdic Project Developer : (ehacker@korea.com)"); 
    wbkgd(about, COLOR_PAIR(1));
    refresh();
    wgetch(about);
    delwin(about);
}

void  find_window(char * word)
{
    int ch,cnt;
    char buff[WORDLENGTH]={'\0',};
    WINDOW *find;
    find = newwin(7, 55, 7, 10);
    box(find, ACS_VLINE, ACS_HLINE);
    wmove(find, 1, 2);
    wprintw(find, "Find : "); 
    wbkgd(find, COLOR_PAIR(1));

    for(ch=wgetch(find),cnt=0;ch != '\n';ch=wgetch(find),cnt++)
    {
	 waddch(find, ch | COLOR_PAIR(COLOR_BLACK));
	 if(cnt >WORDLENGTH)
	     break;
	 buff[cnt]=(char)ch;
    }
    wprintw(find, "\n"); 
    wprintw(find, "server conneting ..... just wait "); 

    strncpy(word,buff,WORDLENGTH);
    refresh();
    delwin(find);

}
void  save_window(char * filename)
{
    int ch,cnt;
    WINDOW *save;
    char buff[FILELENGTH]={'\0',};

    save = newwin(7, 55, 7, 10);
    box(save, ACS_VLINE, ACS_HLINE);
    wmove(save, 1, 2);
    wprintw(save, "Save as : "); 
    wbkgd(save, COLOR_PAIR(1));

    for(ch=wgetch(save),cnt=0;ch != '\n';ch=wgetch(save),cnt++)
    {
	 waddch(save, ch | COLOR_PAIR(COLOR_BLACK));

	 if(cnt >FILELENGTH)
	     break;

	 buff[cnt]=(char)ch;
    }
    strncpy(filename,buff,FILELENGTH);
    refresh();
    delwin(save);
}

void  print_window()
{
    WINDOW *print;

    print = newwin(7, 40, 7, 10);
    box(print, ACS_VLINE, ACS_HLINE);
    wmove(print, 1, 2);
    wprintw(print, "Your System installed h2ps program.\n"); 
    wmove(print, 2, 2);
    wprintw(print, "h2ps program is printing hangle.\n"); 
    wmove(print, 3, 2);
    wprintw(print,"\n"); 
    wmove(print, 4, 2);
    wprintw(print, "press any key..... PRINTING..."); 
    wbkgd(print, COLOR_PAIR(1));

    refresh();
    wgetch(print);
    delwin(print);
}

int check_quit()
{
    WINDOW *check;
    int key;
    check = newwin(3, 40, 5, 10);
    wmove(check, 1, 2);
    wprintw(check, "Exit Wdic (y/n) ? "); 
    wbkgd(check, COLOR_PAIR(1));
    box(check, ACS_VLINE, ACS_HLINE);
    refresh();
    key = wgetch(check);
    delwin(check);
    if (key == 'y')
        return 1;
    else 
        return 0;
}

WINDOW **help_menu_list(int start_col)
{
    int i;
    WINDOW **items;

    items=(WINDOW **)malloc(3 * sizeof(WINDOW *));

    items[0]=newwin(4,19,4,start_col);
    wbkgd(items[0], COLOR_PAIR(1));
    box(items[0],ACS_VLINE, ACS_HLINE);

    items[1]=subwin(items[0], 1, 17, 5, start_col+1);
    items[2]=subwin(items[0], 1, 17, 6, start_col+1);
	wprintw(items[1], "help");
        wprintw(items[2], "about");
    wbkgd(items[1], COLOR_PAIR(1));
    wrefresh(items[0]);
    return items;
}

void delete_menu(WINDOW **items, int count)
{
    int i;
    for (i = 0; i < count; i++)
        delwin(items[i]);
    free(items);
}

int scroll_menu(WINDOW **items,int count,int menu_start_col, int index_num)
{
    int key;
    int selected=0;
    while (1) 
    {
        key=getch();
        if (key==KEY_DOWN || key==KEY_UP) 
        {
            wbkgd(items[selected+1],COLOR_PAIR(2));
            wnoutrefresh(items[selected+1]);
            if (key==KEY_DOWN) 
            {
                selected=(selected+1) % count;
            } 
            else 
            {
                selected=(selected+count-1) % count;
            }
            wbkgd(items[selected+1],COLOR_PAIR(1));
            wnoutrefresh(items[selected+1]);
            doupdate();
        } 
        else if (key==ESCAPE) 
        {
            return -1;
        } 
        else if (key==ENTER) 
        {
            return selected;
        }
    }
}

void init_scr()
{
    initscr();
    start_color();
    init_pair(1, COLOR_WHITE, COLOR_BLACK);
    init_pair(2, COLOR_BLACK, COLOR_WHITE);
    curs_set(2);
    noecho();
    keypad(stdscr, TRUE);
}

void make_menubar()
{
    move(2, 2);
    printw("find : %s",Rfind->userword); 
    move(2, 30);
    addstr("Help");
    addstr("(h)");
    move(3,1);
    hline('_',ACS_HLINE);
}


int windows_main()
{
    WINDOW *menubar, *statusbar, *about;
    int key,i;
    int node_cnt=1;
    FILE *fp;
    char word[WORDLENGTH];
    char filename[FILELENGTH];
    Node * TmpRword;

    init_scr();
    bkgd(COLOR_PAIR(1));
    box(stdscr, ACS_VLINE, ACS_HLINE);
    Rword=find_head->head;
    Rfind=find_head;
    make_menubar();
    move(5,5);
    printw("\n");
    printw("%s",Rword->word);

    while(1)
    {
        WINDOW **menu_items;            
        int selected_item;

	box(stdscr, ACS_VLINE, ACS_HLINE);
        make_menubar();
        key = getch();

	//   Ű  ȭ Ʈ Ѵ.

	if(key == '\n' || key == 'p' || key == 'n' || key == 'P' || key == 'N')
	{
		erase();
		touchwin(stdscr);
		refresh();
	}

        if (key == '\n')
        {
        	Rword=Rword->next;
		if(Rword == Rfind->tail) //  ̶ .
		{
		    if (check_quit() == 1)
			break;
		    else
			    Rword=Rfind->tail->prev;  
		}
		else
		    node_cnt++;

		move(5,5);
		printw("\n");
		printw("%s",Rword->word);
        }
	else if (key == 'p')
        {
		Rword=Rword->prev;
		if(Rword ==Rfind->head)
		    node_cnt=1;
		else
		    node_cnt--;

	        move(5,5);
	        printw("\n");
	        printw("%s",Rword->word);
        }
	else if (key == 'P')
        {
	        Rfind->savereadnode=node_cnt;
	        Rfind=Rfind->prev;
		Rword=Rfind->head;

		if(Rfind->savereadnode <2)
		    ;
		else
		    for(i=1;i<Rfind->savereadnode;i++)
			Rword=Rword->next;
		node_cnt=Rfind->savereadnode;
		move(5,5);
		printw("\n");
		printw("%s",Rword->word);
        }
	else if (key == 'n')
        {
		Rword=Rword->next;
		if(Rword == Rfind->tail) // tail ̳̹Ƿ (ܾ ) 
			Rword=Rfind->tail->prev;
		else
		    node_cnt++;
		    
	        move(5,5);
	        printw("\n");
	        printw("%s",Rword->word);
        }
	else if (key == 'N')
        {
	        Rfind->savereadnode=node_cnt;
	        Rfind=Rfind->next;
		if(Rfind == find_tail)
		    Rfind=Rfind->prev;
		Rword=Rfind->head;

		if(Rfind->savereadnode <2)
		    ;
		else
		    for(i=1;i<Rfind->savereadnode;i++)
			Rword=Rword->next;

		node_cnt=Rfind->savereadnode;
		move(5,5);
		printw("\n");
		printw("%s",Rword->word);
        }
	else if (key == 'f')
        {
	        Rfind->savereadnode=node_cnt;
                find_window(word);

		Rfind=find_head;
		while(1)
		{
		    if(Rfind == find_tail)
		    {
		    	Rfind=NULL;
			break;
		    }

		    if(!strcmp(Rfind->userword,word))
			break;

		    Rfind=Rfind->next;
		}

		if(Rfind == NULL)
		{
		    Rfind=get_findnode(word);
		    submit(word);
		    node_cnt=1;
		    Rword=Rfind->head;
		}
		else
		{
		    Rword=Rfind->head;
		    for(i=1;i<Rfind->savereadnode;i++)
			Rword=Rword->next;
		    node_cnt=Rfind->savereadnode;
		}

		erase();
		touchwin(stdscr);
		refresh();
		move(5,5);
		printw("\n");
		printw("%s",Rword->word);
        }
	else if (key == 's')
        {
	        TmpRword=Rword;
		save_window(filename);
		fp=fopen(filename,"a+");
		if(fp== NULL)
		    ;
		else
		{
		    for(Rword=Rfind->head;Rword != Rfind->tail ;Rword=Rword->next)
			fputs(Rword->word,fp);
		    fclose(fp);
		}
		Rword=TmpRword;
        }
	else if (key == 'O')
        {
	        TmpRword=Rword;
		print_window();
		fp=fopen(".wdictmp","w");
		if(fp== NULL)
		    ;
		else
		{
		    for(Rword=Rfind->head;Rword != Rfind->tail ;Rword=Rword->next)
			fputs(Rword->word,fp);
		    fclose(fp);

		    system("h2ps .wdictmp | lpr");
		    unlink(".wdictmp");
		}
		Rword=TmpRword;
        }
	else if (key == 'h')
        {
            menu_items=help_menu_list(20);
            selected_item = scroll_menu(menu_items, 2, 0, 1); 
            delete_menu(menu_items, 3);
            if (selected_item == 1)
            {
                help_window();
            }
	    else if (selected_item == 0)
            {
                about_window();
            }
            if (selected_item < 0)
                ;//haven't selected any item
            
        }
	else if (key == ESCAPE || key == 'q')
        {
            if (check_quit() == 1)
                break;
	    else
	    {
	        move(5,5);
	        printw("%s",Rword->word);
	    }
        }
    }
    endwin();
}
