#include "dwindow.h"
#include "dlist.h"

extern Node *head,*tail,*Rword;

void help_window()
{
    WINDOW *help;
    help = newwin(6, 40, 7, 10);
    box(help, ACS_VLINE, ACS_HLINE);
    wmove(help, 1, 2);
    wprintw(help, "p : previour display"); 
    wmove(help, 2, 2);
    wprintw(help, "n : next display"); 
    wmove(help, 3, 2);
    wprintw(help, "q : wdic exit"); 
    wbkgd(help, COLOR_PAIR(1));
    refresh();
    wgetch(help);
    delwin(help);
}
void about_window()
{
    WINDOW *about;
    about = newwin(7, 55, 7, 10);
    box(about, ACS_VLINE, ACS_HLINE);
    wmove(about, 1, 2);
    wprintw(about, "Wdic ver: 2.0"); 
    wmove(about, 2, 2);
    wprintw(about, "Last Date : 2003.12.20"); 
    wmove(about, 3, 2);
    wprintw(about, "Wdic Project Manager :  (s970501@hotmail.com)"); 
    wmove(about, 4, 2);
    wprintw(about, "Wdic Project Developer : (ehacker@korea.com)"); 
    wbkgd(about, COLOR_PAIR(1));
    refresh();
    wgetch(about);
    delwin(about);
}

int check_quit()
{
    WINDOW *check;
    int key;
    check = newwin(3, 40, 5, 10);
    wmove(check, 1, 2);
    wprintw(check, "Exit Wdic (y/n) ? "); 
    wbkgd(check, COLOR_PAIR(1));
    box(check, ACS_VLINE, ACS_HLINE);
    refresh();
    key = wgetch(check);
    delwin(check);
    if (key == 'y')
        return 1;
    else 
        return 0;
}

WINDOW **help_menu_list(int start_col)
{
    int i;
    WINDOW **items;

    items=(WINDOW **)malloc(3 * sizeof(WINDOW *));

    items[0]=newwin(4,19,4,start_col);
    wbkgd(items[0], COLOR_PAIR(1));
    box(items[0],ACS_VLINE, ACS_HLINE);

    items[1]=subwin(items[0], 1, 17, 5, start_col+1);
    items[2]=subwin(items[0], 1, 17, 6, start_col+1);
	wprintw(items[1], "help");
        wprintw(items[2], "about");
    wbkgd(items[1], COLOR_PAIR(1));
    wrefresh(items[0]);
    return items;
}

void delete_menu(WINDOW **items, int count)
{
    int i;
    for (i = 0; i < count; i++)
        delwin(items[i]);
    free(items);
}

int scroll_menu(WINDOW **items,int count,int menu_start_col, int index_num)
{
    int key;
    int selected=0;
    while (1) 
    {
        key=getch();
        if (key==KEY_DOWN || key==KEY_UP) 
        {
            wbkgd(items[selected+1],COLOR_PAIR(2));
            wnoutrefresh(items[selected+1]);
            if (key==KEY_DOWN) 
            {
                selected=(selected+1) % count;
            } 
            else 
            {
                selected=(selected+count-1) % count;
            }
            wbkgd(items[selected+1],COLOR_PAIR(1));
            wnoutrefresh(items[selected+1]);
            doupdate();
        } 
        else if (key==ESCAPE) 
        {
            return -1;
        } 
        else if (key==ENTER) 
        {
            return selected;
        }
    }
}

void init_scr()
{
    initscr();
    start_color();
    init_pair(1, COLOR_WHITE, COLOR_BLACK);
    init_pair(2, COLOR_BLACK, COLOR_WHITE);
    curs_set(2);
    noecho();
    keypad(stdscr, TRUE);
}

void make_menubar()
{
    move(2, 2);
    printw("find : %s",head->word); 
    move(2, 30);
    addstr("Help");
    addstr("(h)");
    move(3,1);
    hline('_',ACS_HLINE);
}


int windows_main()
{
    WINDOW *menubar, *statusbar, *about;
    int key;
    int clear_flag=0;

    init_scr();
    bkgd(COLOR_PAIR(1));
    box(stdscr, ACS_VLINE, ACS_HLINE);
    make_menubar();
    Rword=head->next;
    move(5,5);
    printw("\n");
    printw("%s",Rword->word);

    while(1)
    {
        WINDOW **menu_items;            
        int selected_item;

	box(stdscr, ACS_VLINE, ACS_HLINE);
        make_menubar();
        key = getch();

	//   Ű  ȭ Ʈ Ѵ.

	if(key == '\n' || key == 'p' || key == 'n')
	{
		erase();
		touchwin(stdscr);
		refresh();
	}

        if (key == '\n')
        {
        	Rword=Rword->next;
		if(Rword == tail) //  ̶ .
		{
		    if (check_quit() == 1)
			break;
		    else
			    Rword=tail->prev;  
		}
		move(5,5);
		printw("\n");
		printw("%s",Rword->word);
        }
	else if (key == 'p')
        {
		Rword=Rword->prev;
		if(Rword == head) // head ̳̹Ƿ (ܾ ó) 
		{
			Rword=head->next;
		}
	        move(5,5);
	        printw("\n");
	        printw("%s",Rword->word);
        }
	else if (key == 'n')
        {
		Rword=Rword->next;
		if(Rword == tail) // tail ̳̹Ƿ (ܾ ) 
		{
			Rword=tail->prev;
		}
	        move(5,5);
	        printw("\n");
	        printw("%s",Rword->word);
        }
	else if (key == 'h')
        {
            menu_items=help_menu_list(20);
            selected_item = scroll_menu(menu_items, 2, 0, 1); 
            delete_menu(menu_items, 3);
            if (selected_item == 1)
            {
                help_window();
            }
	    else if (selected_item == 0)
            {
                about_window();
            }
            if (selected_item < 0)
                ;//haven't selected any item
            
        }
	else if (key == ESCAPE || key == 'q')
        {
            if (check_quit() == 1)
                break;
	    else
	    {
	        move(5,5);
	        printw("%s",Rword->word);
	    }
        }
    }
    endwin();
}
