package com.hangum.vocabulary.preferences;

import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.StringButtonFieldEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

import com.hangum.vocabulary.VocabularyActivator;

/**
 * This class represents a preference page that
 * is contributed to the Preferences dialog. By 
 * subclassing <samp>FieldEditorPreferencePage</samp>, we
 * can use the field support built into JFace that allows
 * us to create a page that is small and knows how to 
 * save, restore and apply itself.
 * <p>
 * This page is used to modify preferences only. They
 * are stored in the preference store that belongs to
 * the main plug-in class. That way, preferences can
 * be accessed directly via the preference store.
 */

public class VocabularyPreferencePage
	extends FieldEditorPreferencePage
	implements IWorkbenchPreferencePage {
	
	FileFieldEditor ffe = null;

	public VocabularyPreferencePage() {
		super(GRID);
		setPreferenceStore(VocabularyActivator.getDefault().getPreferenceStore());
		setDescription("ܾ ִ  ϼ. ܾ *.txt̾ մϴ.");
	}
	
	/**
	 * Creates the field editors. Field editors are abstractions of
	 * the common GUI blocks needed to manipulate various types
	 * of preferences. Each field editor knows how to save and
	 * restore itself.
	 */
	public void createFieldEditors() {
		ffe = new FileFieldEditor(PreferenceConstants.P_PATH, "&File", getFieldEditorParent());
		ffe.setFileExtensions(new String[] {"*.txt"});
		ffe.setEmptyStringAllowed(false);
		
		addField(ffe);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchPreferencePage#init(org.eclipse.ui.IWorkbench)
	 */
	public void init(IWorkbench workbench) {
	}
	
	@Override
	protected void checkState() {
		// TODO Auto-generated method stub
		super.checkState();
		
		if(!isValid()) return;
		
		System.out.println("[õ ]" + ffe.getStringValue());
		if(ffe.getStringValue().equals("")) {
			setErrorMessage("ܾ ϼ.");
			setValid(false);
		} else {
			setErrorMessage(null);
			setValid(true);
		}
	}
	
}