package viewer;

import java.util.Collection;
import java.util.Iterator;

import javax.swing.JTable;

import datatypes.FlatProfileInfo;

public class Flat{
	JTable table;
	Collection<FlatProfileInfo> list;
	/**
	 * 
	 */
	private static final long serialVersionUID = -314609220014565304L;
	
	public Flat(Collection<FlatProfileInfo> list){
		this.list = list;
		String[] colunmNames = {"name", "%time", "cumulative seconds", "self seconds", "calls", "self ms/calls", "total ms/calls"};
		
		String[][] tableData = new String[list.size()][7]; 
		
		int i=0;
		Iterator<FlatProfileInfo> it = list.iterator();
		
		while(it.hasNext()){
			FlatProfileInfo info = it.next();
			
			tableData[i][0] = info.getName();
			tableData[i][1] = ""+info.getTime();
			tableData[i][2] = ""+info.getCSeconds();
			tableData[i][3] = ""+info.getSSeconds();
			tableData[i][4] = ""+info.getCalls();
			tableData[i][5] = ""+info.getSelfCall();
			tableData[i++][6] = ""+info.getTotalCall();
		}
		
		table = new JTable(tableData, colunmNames);
	}
	
	public JTable getTable(){
		return table;
	}

}
